

  function addCopyToClipboardEvent(selectors) {
    selectors.forEach(function (selector) {
      var elements = document.querySelectorAll(selector);

      if (elements.length === 0) {
        console.error("No se encontraron elementos con el selector: " + selector);
        return;
      }

      elements.forEach(function (element) {
        element.addEventListener('click', function () {
          var formattedValue = element.getAttribute('data-formatted-value');

          var tempElement = document.createElement('textarea');
          tempElement.value = formattedValue;
          document.body.appendChild(tempElement);

          tempElement.select();
          document.execCommand('copy');

          document.body.removeChild(tempElement);

          // Muestra la notificación de éxito específica para este elemento
          app.helper.showSuccessNotification({ message: 'Valor Copiado: ' + formattedValue });
        });
      });
    });
  }




  
/**
 * Formatea un número con la cantidad de decimales y los separadores especificados.
 *
 * @param {number} number - El número a formatear.
 * @param {number} [decimales=0] - La cantidad de decimales a mostrar.
 * @param {string} [separatorMiles=','] - El separador de miles.
 * @param {string} [separatorDecimal='.'] - El separador decimal.
 * @returns {string} - El número formateado como cadena.
 */
function formatNumber(number, decimales = 0, separatorMiles = ',', separatorDecimal = '.') {
    // Validar que 'decimales' sea un número positivo
    if (typeof decimales !== 'number' || decimales < 0) {
        console.error("El parámetro 'decimales' debe ser un número positivo.");
        return number.toString(); // Devuelve la cadena original si 'decimales' no es válido.
    }

    // Convertir 'number' a un objeto Number.
    var numberObj = new Number(number);

    // Multiplicar por 10^decimales para preservar los decimales
    var factor = Math.pow(10, decimales);
    var roundedNumber = Math.round(numberObj * factor) / factor;

    // Convertir el número redondeado en una cadena con el número correcto de decimales
    var formattedNumber = roundedNumber.toFixed(decimales);

    // Aplicar separadores de miles a la parte entera del número.
    var parts = formattedNumber.split('.');
    parts[0] = parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, separatorMiles);

    // Unir las partes con el separador decimal adecuado
    var result = parts.join(separatorDecimal);
	// Verificar si el resultado es NaN después del formateo
	if (isNaN(parseFloat(result))) {
		//console.warn("El número después del formateo es NaN.");
		return number.toString(); // Devuelve la cadena original en caso de NaN.
	  }
	
    // Devolver el resultado
    return result;
}

  



/**
 * Llena los campos de un formulario con datos de ubicación (ubigeo).
 *
 * @param {object} objubigeo - Objeto que contiene los valores de ubicación.
 * @param {object} objubigeo.pais - Objeto con información del país.
 * @param {string} objubigeo.pais.name - Nombre del campo de país.
 * @param {string} objubigeo.pais.value - Valor del país.
 * @param {object} objubigeo.departamento - Objeto con información del departamento.
 * @param {string} objubigeo.departamento.name - Nombre del campo de departamento.
 * @param {string} objubigeo.departamento.value - Valor del departamento.
 * @param {object} objubigeo.distrito - Objeto con información del distrito.
 * @param {string} objubigeo.distrito.name - Nombre del campo de distrito.
 * @param {string} objubigeo.distrito.value - Valor del distrito.
 * @param {object} objubigeo.provincia - Objeto con información de la provincia.
 * @param {string} objubigeo.provincia.name - Nombre del campo de provincia.
 * @param {string} objubigeo.provincia.value - Valor de la provincia.
 */
const Ubigeo_GetData = (objubigeo) => {
    let obj = {};
    if (select(`[name=${objubigeo.pais.name}]`)) select(`[name=${objubigeo.pais.name}]`).value = objubigeo.pais.value;
    if (select(`[name=${objubigeo.departamento.name}]`)) select(`[name=${objubigeo.departamento.name}]`).value = objubigeo.departamento.value;
    if (select(`[name=${objubigeo.distrito.name}]`)) select(`[name=${objubigeo.distrito.name}]`).value = objubigeo.distrito.value;
    if (select(`[name=${objubigeo.provincia.name}]`)) select(`[name=${objubigeo.provincia.name}]`).value = objubigeo.provincia.value;
};



function FormatDobleAllView() {
	let inputs = document.querySelectorAll('input[data-field]'); // Edit
	let spans = document.querySelectorAll('span[data-field-type="double"]');
	let tds = document.querySelectorAll('td[data-field-type="double"]');
	
	inputs.forEach(function (inputElement) {
		let dataField = JSON.parse(inputElement.dataset.field);
		if (dataField.type === "double") {
		  let originalValue = inputElement.value.trim();

		  //--- obtener configuracion del campo
		  const miles = inputElement.getAttribute('data-group-separator', originalValue);
		  const decimal=inputElement.getAttribute('data-number-of-decimal-places', originalValue);

		  inputElement.value = formatNumber(originalValue, 2, miles, decimal);
		  inputElement.setAttribute('data-value', originalValue);
		}
	  });


	spans.forEach(function (span) {
		let originalValue = span.textContent.trim();
		//--- obtener configuracion del campo
		const miles = span.getAttribute('data-group-separator');
		const decimal=span.getAttribute('data-number-of-decimal-places');

		console.log(span, miles, decimal)

		let formattedValue = formatNumber(originalValue, 2, miles, decimal);


		
		// Establecer el valor formateado como un atributo del td
		span.setAttribute('data-value', originalValue);
		span.textContent = formattedValue;
	});


	tds.forEach(function (td) {
		var originalValue = td.textContent.trim();

		const miles = td.getAttribute('data-group-separator', originalValue);
		const decimal=td.getAttribute('data-number-of-decimal-places', originalValue);
		let formattedValue = formatNumber(originalValue, 2, miles, decimal);
		
		// Establecer el valor formateado como un atributo del td
		td.setAttribute('data-value', originalValue);
		td.textContent = formattedValue;
	});
  }


  
  function FormatNumberAllView() {
	let inputs = document.querySelectorAll('input[data-field]'); // Edit
	let spans = document.querySelectorAll('span[data-field-type="integer"]');
	let tds = document.querySelectorAll('td[data-field-type="integer"]');
	
	inputs.forEach(function (inputElement) {
		let dataField = JSON.parse(inputElement.dataset.field) 
		console.log(inputElement,dataField.type)
		if(dataField.type === "integer") {
				let originalValue = inputElement.value.trim();
				inputElement.value = formatNumber(originalValue);	
				inputElement.setAttribute('data-value', originalValue);
		}
	});

	spans.forEach(function (span) {
		var originalValue = span.textContent.trim();
		var formattedValue = formatNumber(originalValue);
		
		// Establecer el valor formateado como un atributo del td
		span.setAttribute('data-value', originalValue);
		span.textContent = formattedValue;
	});


	tds.forEach(function (td) {
		var originalValue = td.textContent.trim();
		var formattedValue = formatNumber(originalValue);
		
		// Establecer el valor formateado como un atributo del td
		td.setAttribute('data-value', originalValue);
		td.textContent = formattedValue;
	});
  }

  function initFormatAllView(){
	FormatDobleAllView();
	//FormatNumberAllView();
}
  


























function AccountsEdit_Init(){
	/*----- Ubigueo ------*
	var objubigeoAccounts={
		ubigeo:'[name=cf_918]', // campo Ubigeo
		departamento:'[name=bill_pobox]',// campo departamento
		distrito:'[name=bill_city]',// campo distrito
		provincia:'[name=bill_state]',// campo provincia
	};
	Ubigeo_GetData(objubigeoAccounts);// ejecucion
	$('input[name=cf_918_display]').change(()=> Ubigeo_GetData(objubigeoAccounts)); // ejecutar al escribir en el campo relacional
	//*.--------------------*/
}

//------------------------./


/**
 * Ejecutar funciones por Modulos y Vistas
 * 	Declarado
 * 		- layouts/v7/modules/Vtiger/resources/Popup.js => Se ejecuta luego de dar clic al valor del Popup* 	
 * 		- registerEventForListViewEntryClick : function() 
 * 			-dentro de esta funcion 'popupPageContentsContainer.on('click','.listViewEntries',function(e))'	
 * 			
 * @param {_META.module}	=> Modulo 
 * @param {_META.view}		=> Vista
 */
function CaseModules(){
		_META.URL = purl(window.document.URL).data.param.query;

	//Object.freeze(_META)
	debuglog( _META,'/resources/CreantisJsFooter.js');
	switch (_META.module) {
		case 'Accounts':
			switch (_META.view) {
				case 'Edit':
					if (typeof AccountsEdit_Init === 'function') AccountsEdit_Init(); 
				break;
			
				default:
				break;
			}
		break;
	}
	debuglog( {},'CaseModules');
}


			




/**
 * Hook Js
 * Declarado en => layouts/v7/modules/Vtiger/resources/Vtiger.js => ln 889
 * Funcion que se ejecuta al al limpiar un campo de modulo relacional
 * @param {*} fieldName =>nombre del campo
 */
function ClearForX_ModuleReference(fieldName){

	console.log('ClearForX_ModuleReference',fieldName)
}


/**
 * Hook Js
 * Declarado en => layouts/v7/modules/Vtiger/resources/Vtiger.js => ln 1568
 * Funcion que se ejecuta al realizar una accion en el campo de modulo relacional
 * @param {*} obj  => modulename, id, input_name
 */
function ReferenceFieldModuleGetDataCase(obj) {
	console.log('ReferenceFieldModuleGetDataCase -> objref',obj);

	requestData(obj.modulerel, 'GetData', obj.idmodulerel)
	.then(function(data) {
		if (data['success']) {
			let dt = data.result.data;
			//console.log('AppConnector', dt);

			// Si el módulo actual es 'Accounts' y el registro fuente es de tipo 'Ubigeo'
			if (obj.module === "Accounts" && dt.record_module === "Ubigeo") {
				Ubigeo_GetData({
					departamento:{ name:'ship_pobox', value:dt.ubigeo_tks_departamento },
					distrito:{ name:'ship_city', value:dt.ubigeo_tks_distrito },
					provincia:{ name:'ship_state', value:dt.ubigeo_tks_provincia },
					pais:{ name:'bill_country', value:dt.ubigeo_tks_pais },
				});
			}
			// Si el módulo actual es 'Contacts' y el registro fuente es de tipo 'Ubigeo'
			if (obj.module === "Contacts" && dt.record_module === "Ubigeo")
				Ubigeo_GetData({
					departamento:{ name:'mailingpobox', value:dt.ubigeo_tks_departamento },
					distrito:{ name:'mailingcity', value:dt.ubigeo_tks_distrito },
					provincia:{ name:'mailingstate', value:dt.ubigeo_tks_provincia },
					pais:{ name:'mailingcountry', value:'' },
				});

		}
	})

}


/**
 * Hook Js
 * Declarado en => layouts/v7/modules/Vtiger/resources/Detail.js::registerRelatedRowClickEvent => ln 673
 * Declarado en => layouts/v7/modules/Vtiger/resources/Edit.js::registerPageLeaveEvents => ln 350
 * Funcion que se ejecuta para traer el diccionario SC y bloquear campos 
 * @param {*} fieldName =>nombre del campo
 */
function EventsEditDetailModuleRelation(modulo, view, record) {
	console.log('EventsEditDetailModuleRelation',modulo, view, record); 
	initFormatAllView()
}


/**
 * Declarado en => layouts/v7/modules/Vtiger/resources/Detail.js => ln 747 :registerEventsForRelatedList
 * Funcion que se ejecuta despues de cargar una lista relacional
 */
function FinallyLoadListRel(){
	console.log('FinallyLoadListRel')
	initFormatAllView()
	/*
	.finally( ()=>{
		//Creantis - cgarcia llamado despues de cargar una lista 
		if (typeof FinallyLoadListRel === 'function') FinallyLoadListRel();
		
	})
	debugger
*/
}


document.addEventListener("DOMContentLoaded", ()=> CaseModules(),initFormatAllView() );
document.addEventListener("DOMContentLoaded", function(event) { });