<?php

chdir("../../");
require_once 'data/CRMEntity.php';
include_once 'includes/main/WebUI.php';
include_once 'vtlib/Vtiger/Module.php';
require_once 'includes/Loader.php';
require_once 'include/utils/utils.php';

vimport('includes.http.Request');
vimport('includes.runtime.Globals');
vimport('includes.runtime.BaseModel');
vimport ('includes.runtime.Controller');
vimport('includes.runtime.LanguageHandler');

ini_set('max_execution_time', 0);
set_time_limit(0);

global $current_user;
$current_user->id = 1;
/**
 * @method Retorna el nombre del rol que debe tener el usuario
 * @param string $tipo : b2c|b2b
 * @param integer $seccion
 * @param integer $grupo
 * 
 * @return string|null
 */
function getRole($tipo, $seccion, $grupo)
{
    global $adb;
    switch ($tipo) {
        case 'b2c': $pref = 'Jefe de Sucursal ';                break;
        case 'b2b': $pref = 'Gerentes de ventas corporativas ';  break;
    }
    $tx = $pref.$seccion.".".$grupo;
    #Busca la existencia del rol en la BD 
    $r = $adb->pquery("SELECT roleid FROM vtiger_role WHERE rolename like '%".$tx."%'",[]);

    return $adb->num_rows($r) == 1 ? decode_html($adb->query_result($r,0,'roleid')) : "";
}

/**
 * @method Rellena el Objeto usuario con los datos por defecto
 * @param object $userModel : Objeto usuario
 * @param array $attr : atributos
 * 
 * @return void
 */
function fillUserData(&$userCModel, $attr)
{
    if(!empty($userCModel))
    {
        foreach ($attr as $key => $value) {
            $userCModel->set($key,$value);
        }
    }
}


/**
 * Script para poblar los usuarios
 */
function main()
{
    global $adb;
    $userCModel     = Users_Record_Model::getCleanInstance('Users'); #Instancia un model limpio de usuario
    $userB2C_prex   = "usuariob2c"; #Prefijo para usuarios B2C
    $userB2B_prex   = "usuariob2b"; #Prefijo para usuarios B2B
    #Parametros de iteración:
    $c_secciones        = 8; #Cantidad de secciones
    $c_grupo            = 8; #Cantidad de grupo x secciones
    $c_usuariosxgrupo   = 7; #Cantidad de Usuarios x grupo

    #Datos por dummy de los usuarios:
    $attr = [
        'email1'        => 'dummy@test.com',
        'first_name'    => 'User',
        'last_name'     => 'Dummy',
        'user_password' => '*Ud1mM!_*[2023!]',
        'confirm_password' => '*Ud1mM!_*[2023!]',
        'no_of_currency_decimals' => 2,
        'currency_grouping_separator' => ",",
        'date_format' => 'dd-mm-yyyy',
        'language' => 'es_pe',
        'time_zone' => 'America/Lima'
    ];

   
    debug("[INFO]:: GENERANDO USUARIOS...");
    #NO TOCAR - GENERA USUARIOS
    for ($seccion=1; $seccion <= $c_secciones; $seccion++) { 
        debug("[INFO]:: SECCIÓN ".$seccion);
        for ($grupo=1; $grupo <= $c_grupo; $grupo++) { 
            debug("[INFO]:: GRUPO ".$grupo);
            for ($i=1; $i <= $c_usuariosxgrupo; $i++) { 
                # ----------------------- USUARIO B2C -----------------------------#

                $username_b2c = $userB2C_prex.$seccion.$grupo."_".$i;
                #Valida que el usuario no exista
                $query_v1 = $adb->pquery("SELECT 1 FROM vtiger_users WHERE user_name = ?",[$username_b2c]);

                if(empty($adb->num_rows($query_v1))){
                    #Valida si el que se va a asignar exista
                    $rol_ = getRole('b2c',$seccion,$grupo);

                    if(!empty($rol_))
                    {
                        $userCModel_b2c = clone $userCModel;
                        $userCModel_b2c->set('mode','');
                        $userCModel_b2c->set('user_name',$username_b2c);
                        $userCModel_b2c->set('roleid',$rol_);
                        $userCModel_b2c->set('gerencia',"Sucursal ".$grupo);
                        fillUserData($userCModel_b2c,$attr);
                        try {
                            $userCModel_b2c->save();
                            $userid = $userCModel_b2c->getId();
                            if(!empty($userid))
                                debug("[INFO]:: USUARIO $username_b2c CREADO SATISFACTORIAMENTE.");
                            else debug("[ERROR]:: USUARIO $username_b2c NO CREADO.");
                        } catch (Exception $e) {
                            debug("[ERROR]:: EXCEPCION AL CREAR EL USUARIO ".$username_b2c." => ".$e->getMessage());
                        }
                    }
                    else{
                        debug("[ERROR]:: NO SE ENCONTRÓ UN ROL PARA EL USUARIO: ".$username_b2c);
                    }
                }
                else{
                    debug("[ERROR]:: YA EXISTE EL USUARIO: ".$username_b2c);
                }

                # ----------------------- FIN USUARIO B2C ----------------------------- #
                # ----------------------- USUARIO B2B -----------------------------#
                $username_b2b = $userB2B_prex.$seccion.$grupo."_".$i;
                $query_v2 = $adb->pquery("SELECT 1 FROM vtiger_users WHERE user_name = ?",[$username_b2b]);
                if(empty($adb->num_rows($query_v2))){
                    #Valida si el que se va a asignar exista
                    $rol_ = getRole('b2b',$seccion,$grupo);

                    if(!empty($rol_))
                    {
                        $userCModel_b2b = clone $userCModel;
                        $userCModel_b2b->set('mode','');
                        $userCModel_b2b->set('user_name',$username_b2b);
                        $userCModel_b2b->set('roleid',$rol_);
                        $userCModel_b2b->set('gerencia',"Corporativa ".$grupo);
                        fillUserData($userCModel_b2b,$attr);
                        try {
                            $userCModel_b2b->save();
                            $userid = $userCModel_b2b->getId();
                            if(!empty($userid))
                                debug("[INFO]:: USUARIO $username_b2b CREADO SATISFACTORIAMENTE.");
                            else debug("[ERROR]:: USUARIO $username_b2b NO CREADO.");
                        } catch (Exception $e) {
                            debug("[ERROR]:: EXCEPCION AL CREAR EL USUARIO ".$username_b2b." => ".$e->getMessage());
                        }
                    }
                    else{
                        debug("[ERROR]:: NO SE ENCONTRÓ UN ROL PARA EL USUARIO: ".$username_b2b);
                    }
                }
                else{
                    debug("[ERROR]:: YA EXISTE EL USUARIO: ".$username_b2b);
                }
                # ----------------------- USUARIO B2B -----------------------------#
            }
        }
    }
}

main();