<?php

class Chatgpt_Model {
    static $apiKey = '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';
    static $domain = 'https://api.openai.com/v1/chat/completions';

    static function sendHTPP_request($params = null,$method = 'POST')
    {

        #Activar para debuggear request
        $debug_curl = false;

        if(!empty($params['file']) && file_exists($params['file']))
        {
            $cf = new CURLFile($params['file'],'application/octet-stream','file.txt');
            $postBody["parametros"] = json_encode($params["postBody"]);
            $postBody["archivo"] = $cf;
            $headers = [
                "Content-Type: multipart/form-data",
            ];
        }
        else{
            $postBody = (!empty($params["postBody"])) ? json_encode($params["postBody"]) : NULL;
            $headers = [
                "Accept: application/json",
                "Content-Type: application/json",
            ];
        }

        $headers[] = "Authorization: Bearer ".self::$apiKey;

        $segment = (isset($params["segment"])) ? "/".$params["segment"] : NULL;
        $getParam = isset($params["getParam"]) ? "?".http_build_query($params["getParam"]) : NULL;
        
        if($debug_curl)
        {
            ob_start();  
            $out = fopen('php://output', 'w');
        }
        
        $curl = curl_init();
        
        
        if(!empty($params["headers"]))
        {
            foreach ($params["headers"] as $key => $value) {
                $headers[] = "$key: $value";
            }
        }

        curl_setopt_array($curl, [
            CURLOPT_URL => self::$domain.$segment.$getParam,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => strtoupper($method),
            CURLOPT_POSTFIELDS => $postBody,
            CURLOPT_HTTPHEADER => $headers,
            CURLOPT_SSL_VERIFYHOST => FALSE,
            CURLOPT_SSL_VERIFYPEER => FALSE,
            CURLOPT_HEADER => 1,
        ]);
        if($debug_curl)
        {
            curl_setopt($curl, CURLOPT_VERBOSE, TRUE);  
            curl_setopt($curl, CURLOPT_STDERR, $out);  
            }
        $response = curl_exec($curl);

        $header_size = curl_getinfo($curl, CURLINFO_HEADER_SIZE); 
        list($header, $body) = explode("\r\n\r\n", $response, 2);

        $err = curl_error($curl);
        curl_close($curl);
        if($debug_curl)
        {
            fclose($out);  
            $debug = ob_get_clean();
            debug($debug,true);
        }

        if ($err) {
            echo("cURL Error #:" . $err);
            die;
        } else {
            $result['header'] 	= $header;
            $result['body'] 	= json_decode($body,true);
            $result['http_status'] = curl_getinfo($curl, CURLINFO_RESPONSE_CODE);

            return $result;
        }
        
    }

    static function preguntaChatgpt($pregunta){
        //INICIAMOS LA CONSULTA DE CURL
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://api.openai.com/v1/chat/completions');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'Authorization: Bearer '.self::$apiKey,
        ]);
        //INICIAMOS EL JSON QUE SE ENVIARA A META
        curl_setopt($ch, CURLOPT_POSTFIELDS, "{
            \"model\": \"gpt-3.5-turbo\",
            \"prompt\": \"".$pregunta."\",
            \"max_tokens\": 1000,
            \"temperature\": 1.0
        }");
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        //OBTENEMOS EL JSON COMPLETO CON LA RESPUESTA
        $response = curl_exec($ch);
        curl_close($ch);
        debug($response);
        $decoded_json = json_decode($response, false);
        //RETORNAMOS LA RESPUESTA QUE EXTRAEMOS DEL JSON
        return  $decoded_json->choices[0]->text;    
    }
}