<?php

class vt_restapi {
    private $serveraddress;
    private $crm_username;
    private $crm_useraccesskey;
    private $crm_token;
    private $module;
    private $filter;
    private $limit;

    public function __construct($crm_username, $crm_useraccesskey, $module , $filter ='', $limit ='') {
        $this->serveraddress = self::getDominio();
        $this->crm_username = $crm_username;
        $this->crm_useraccesskey = $crm_useraccesskey;
        $this->module = $module;
        $this->filter = $filter;
        $this->limit = $limit;
    }


    private function makeRequest($url, $method = "GET", $data = []) {
        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => $method,
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_HTTPHEADER => [
                "Content-Type: application/json",
            ],
        ]);
        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        return json_decode($response, true);
    }

    private function getDominio() {
        $obj =(object)[];
        // Obtener la URL actual
        $obj->url_actual = "http://" . $_SERVER["SERVER_NAME"] . $_SERVER["REQUEST_URI"];
    
        // Verificar si se utiliza HTTPS
        if (isset($_SERVER["HTTPS"]) && $_SERVER["HTTPS"] === "on") 
            $obj->url_actual = str_replace("http://", "https://", $obj->url_actual);
    
        // Obtener el nombre de la carpeta padre
        $obj->nombreCarpetaPadre = basename(dirname(__DIR__));
    
        // Encontrar la posición de la palabra "carpeta del archivo"
         $obj->posicion_complemento = strpos($obj->url_actual, "/{$obj->nombreCarpetaPadre}");
        $obj->url = substr($obj->url_actual, 0, $obj->posicion_complemento);
        #echo json_encode($obj);die;
        return $obj->url;
        // Obtener la parte de la URL hasta la carpeta "complemento"
    }

    public function getChallenge() {
        $url = "{$this->serveraddress}/webservice.php?operation=getchallenge&username={$this->crm_username}";
        $response = $this->makeRequest($url);
        $this->crm_token = $response['result']['token'];
    }


    private function login() {
        $service_url = $this->serveraddress."/webservice.php";
        $combined = $this->crm_token.$this->crm_useraccesskey;
        $combined = md5($combined);
        $curl_post_data = array(
            'operation' => 'login',
            'username' => $this->crm_username,
            'accessKey' => $combined
        );

        $curl = curl_init($service_url);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $curl_post_data);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        $curl_response = curl_exec($curl);
        $curl_response = json_decode($curl_response);
        return $curl_response;
    }

    public function getSessionUser(){
        $this->getChallenge();
        return $this->login();
    }


    function api_query() {
        $url = "{$this->serveraddress}/webservice.php";
        $sessionName = self::getSessionUser()->result->sessionName; 

        if(!$this->module) return (object) ['success' =>false , "resp" => 'requiere_parametros', 'url'=>$url];
        $filter =($this->filter)? " WHERE {$this->filter}" : '' ; 
        $limit =($this->limit)? " LIMIT {$this->limit}" : '' ; 

        $params = array(
            'operation' => 'query',
            'sessionName' => $sessionName,
            'query' => "SELECT * FROM {$this->module} {$filter} {$limit};"
        );
    
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url . '?' . http_build_query($params));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);

        if($response === false) return (object) ['success' =>false , "resp" => 'Error en la solicitud cURL: ' . curl_error($ch)];
        curl_close($ch);

            return json_decode($response, true);
        }


}//END CLASS
$restapi = new vt_restapi((string) $_REQUEST['username'],  (string) $_REQUEST['access_key'],  (string) $_REQUEST['module'],  (string) $_REQUEST['filter']);

?>
