<?php

class BasicLDS {
    


    /**
     * Realiza una solicitud POST a una API y procesa la respuesta.
     *
     * @param string $url La URL de la API.
     * @param array $headers Los encabezados de la solicitud.
     * @param array $data El cuerpo de la solicitud en forma de arreglo asociativo.
     * @return array Un arreglo con la respuesta procesada.
     */
    public static function hacerSolicitudAPI($url, $headers, $data, $mapeoNombres = null) {
        // Inicializar cURL
        $ch = curl_init($url);

        // Configurar opciones de cURL
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        // Realizar la solicitud cURL
        $response = curl_exec($ch);

        // Inicializar el arreglo de respuesta
        $responseData = array();

        if ($response === false) {
            // Error de cURL
            $responseData['msj'] = 'Error de cURL: ' . curl_error($ch);
            $responseData['resp'] = false;
        } else {
            // La respuesta es un JSON, decodificarla
            $responseData = json_decode($response, true);

            if ($responseData === null) {
                // Error al decodificar la respuesta JSON
                $responseData['msj'] = 'Error al decodificar la respuesta JSON.';
            } else {
                // Procesar la respuesta
                $responseData = self::procesarArray($responseData, $mapeoNombres);
                //$responseData = $responseData;
            }
        }

        // Cerrar la sesión cURL
        curl_close($ch);
        return $responseData;
    }
}
