{*<!--
 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */
-->*}
<style type="text/css">
  .search-container1 {
position: relative;
/*max-width: 300px;*/
margin: 0 auto;
text-align: center;
padding: 15px 0;
display:block;
}

.modulecontainer{
  padding:15px;
}

.search-title {
margin-top: 0;
margin-bottom: 5px;
color: #1ca0b8;
}

#search-input {
width: 100%;
padding: 13px;
/*border-radius: 4px;*/
/*border: 2px solid #1ca0b8;*/
font-size: 15px;
}

#search-input:focus {
outline: none;
}

#search-results {
position: absolute;
z-index: 10;
/*margin: 1px 0px 0px 8%;*/
background: #FFF;
width: 100%;
text-align: left;
border-radius: 4px;
border: 1px solid #66afe9;
display: none;
}
.search-item {
color: #000;
cursor: pointer;
}
.search-item p {
margin: 0;
padding: 10px;
}
.search-item:hover {
background: #FFF;
}
#search-data {
margin-top: 10px;
color: #1ca0b8;
}
#search-data p {
margin: 0;
padding: 6px;
font-size: 16px;
}
</style>
{strip}
<div class="modal-dialog">
    <div class="modal-content">
            <div class="modal-header">
                <div class="clearfix">
                    <div class="pull-right " >
                        <button type="button" class="close" aria-label="Close" data-dismiss="modal">
                            <span aria-hidden="true" class='fa fa-close'></span>
                        </button>
                    </div>
                    <h4 class="pull-left">
                        {vtranslate('Add Stops - Route Planning','CTMobileSettings')}
                    </h4>
                </div>
            </div>
        <div class="modal-body">
            <div id="popupPageContainer" class="contentsDiv col-sm-12">
                <div id="popupContents" class="">
                    <input type="hidden" id="supportedImageFormats" value='["png"]'/>
                   
                    <div class="row">
                        <div class="col-md-12">
                          <select class="select2 inputElement" name="sourceModule">
                            {foreach item=modulelabel key=modulename from=$ALL_MODULES}
                            <option value="{$modulename}" {if $MODULE_NAME eq $modulename} selected {/if}>{$modulelabel}</option>
                            {/foreach}
                          </select>
                        </div>
                    </div>
                    <div class="row">
                          <div class="col-md-4 modulecontainer" ></div>
                          <div class="col-md-7">
                            <div class="search-container1">
                                <div class="search-engine">
                                <input type="input" class="form-control" name="recordname" id="search-input" autocomplete="off" placeholder="Type and Search" style="display: inline-block;" />
                               <!--  <button type="button" class="btn btn-info" style="background:#287DF2 !important;display: inline-block;" id="addstop"><i class="fa fa-plus"></i> Add Stop</button> -->
                                </div>
                                <div id="search-results"></div>
                                <div id="search-data"></div>
                            </div>
                          </div>
                          <div class="col-md-1" style="padding:15px 0;">
                            <button class="btn btn-info" id="createRecord" title="{vtranslate('Create Record','CTMobileSettings')}"><i class="fa fa-plus"></i></button>
                          </div>
                          <div class="col-md-4">
                              <label>{vtranslate('Priority','CTMobileSettings')}</label>
                          </div>
                          <div class="col-md-8">
                              <select class="select2 inputElement" name="routepriority">
                                  <option value="Low">{vtranslate('Low','CTMobileSettings')}</option>
                                  <option value="Medium">{vtranslate('Medium','CTMobileSettings')}</option>
                                  <option value="High">{vtranslate('High','CTMobileSettings')}</option>
                              </select>
                          </div>
                    </div>
                    <table class="table table-borderless" id="stoptable">
                            <thead>
                                <tr>
                                  <th>{vtranslate('Record Label','CTMobileSettings')}</th>
                                  <th>{vtranslate('Address','CTMobileSettings')}</th>
                                  <th>{vtranslate('Priority','CTMobileSettings')}</th>
                                  <th>{vtranslate('Action','CTMobileSettings')}</th>
                                </tr>
                            </thead>
                            <tbody>
                              
                            </tbody>
                        </table>
            
                </div>
               
            </div>
        </div>
        <div class="modal-footer">
            <a aria-label="Close" data-dismiss="modal">{vtranslate('Close','CTMobileSettings')}</a>&nbsp;&nbsp;
            <button type="button" class="btn btn-success saveButton" id="saveStops" style="background:#287DF2 !important;">{vtranslate('Save Stops','CTMobileSettings')}</button>
        </div>
    </div>
</div>
{/strip}

{literal}
<script type="text/javascript">
    var popupPageContainer = jQuery('#popupPageContainer');
    jQuery(document).ready(function(){

      jQuery(document).on('click','#createRecord,#create_Record',function(){
        var thisInstance = new Vtiger_Index_Js();
          var sourceModule = jQuery('[name="sourceModule"]').val();
          //params['module'] = 'CTMobileSettings';
          //params['view'] = 'CreateRecordAjax';
          //params['sourceModule'] = sourceModule;
          /*var popupInstance = Vtiger_Popup_Js.getInstance();
          var callbackparams = {
            'cb' : function (container){
              thisInstance.registerPostReferenceEvent(container);
              app.event.trigger('post.QuickCreateForm.show',form);
              app.helper.registerLeavePageWithoutSubmit(form);
              app.helper.registerModalDismissWithoutSubmit(form);
            },
            backdrop : 'static',
            keyboard : false
            }
          popupInstance.showPopup(params,function() {},callbackparams);*/
          
          var quickCreateUrl = "index.php?module="+sourceModule+"&view=QuickCreateAjax";
          var quickCreateModuleName = sourceModule;
          if (typeof params === 'undefined') {
            params = {};
          }
          if (typeof params.callbackFunction === 'undefined') {
            params.callbackFunction = function(data, err) {
              //fix for Refresh list view after Quick create
              var parentModule=app.getModuleName();
              var viewname=app.view();
              if((quickCreateModuleName == parentModule) && (viewname=="List")){
                  var listinstance = app.controller();
                  listinstance.loadListViewRecords(); 
              }
            };
          }
          app.helper.showProgress();
          thisInstance.getQuickCreateForm(quickCreateUrl,quickCreateModuleName,params).then(function(data){
            app.helper.hideProgress();
            var callbackparams = {
              'cb' : function (container){
                //container.css('z-index','1111111');
                $('#popupModal').modal('toggle');
                thisInstance.registerPostReferenceEvent(container);
                app.event.trigger('post.QuickCreateForm.show',form);
                app.helper.registerLeavePageWithoutSubmit(form);
                app.helper.registerModalDismissWithoutSubmit(form);
              },
              backdrop : 'static',
              keyboard : false
              }

            app.helper.showModal(data, callbackparams);
            var form = jQuery('form[name="QuickCreate"]');
            var moduleName = form.find('[name="module"]').val();
            app.helper.showVerticalScroll(jQuery('form[name="QuickCreate"] .modal-body'), {'autoHideScrollbar': true});

            var targetInstance = thisInstance;
            var moduleInstance = Vtiger_Edit_Js.getInstanceByModuleName(moduleName);
            if(typeof(moduleInstance.quickCreateSave) === 'function'){
              targetInstance = moduleInstance;
              targetInstance.registerBasicEvents(form);
            }

            vtUtils.applyFieldElementsView(form);
            /*form.on('click','.select2',function(){
              jQuery('.select2-drop').filter(function(index,item){
                  if(jQuery(item).css('display') == 'block'){
                      jQuery(item).css('z-index','1111111');
                  }
              })
            });*/
            targetInstance.quickCreateSave(form,params);
          });
          /*AppConnector.request(params).then(function(data) {
              var callbackparams = {
              'cb' : function (container){
                thisInstance.registerPostReferenceEvent(container);
                app.event.trigger('post.QuickCreateForm.show',form);
                app.helper.registerLeavePageWithoutSubmit(form);
                app.helper.registerModalDismissWithoutSubmit(form);
              },
              backdrop : 'static',
              keyboard : false
              }
              app.helper.showModal(data, callbackparams);
          });*/
      });

      var sourceModule = jQuery('[name="sourceModule"]').val();
      var params = {};
      params['module'] = 'CTMobileSettings';
      params['view'] = 'RoutePlanning';
      params['mode'] = 'getModuleFields';
      params['sourceModule'] = sourceModule;
      AppConnector.request(params).then(function(data) {
          jQuery('.modulecontainer').html(data.result);
          app.changeSelectElementView(popupPageContainer);
                        //register all select2 Elements
          app.showSelect2ElementView(popupPageContainer.find('select.select2'));
      });
      //app.changeSelectElementView(popupPageContainer);
                        //register all select2 Elements
      //app.showSelect2ElementView(popupPageContainer.find('select.select2'));


    });
    /*if (navigator.geolocation) {
      navigator.geolocation.getCurrentPosition((position)=> {
          const p=position.coords;
          console.log(p.latitude,p.longitude);
      });
    }else{
      console.log("Geolocation is not supported by this browser.");
    }*/

    

    jQuery('#saveStops').on('click',function(){
      var trr = jQuery('#stoptable tbody').find('tr');
      var trlength = jQuery('#stoptable tbody').find('tr').length;
      if(trlength == 0){
        var params = {
            title : app.vtranslate('Please add atleast one stop'),
            text: app.vtranslate('Please add atleast one stop'),
            animation: 'show',
            type: 'error'
        };
        Vtiger_Helper_Js.showPnotify(params);
      }else{
      	var priorityHtml = jQuery('[name="routepriority"]').clone();
        priorityHtml.addClass('hide');
        for(var i=0;i<trlength;i++){
          var oldtr = trr[i];
          let tr = document.createElement('tr');
          tr.setAttribute("data-crmid", oldtr.getAttribute('data-crmid'));
          tr.setAttribute("data-label", oldtr.getAttribute('data-label'));
          tr.setAttribute("data-address", oldtr.getAttribute('data-address'));
          tr.setAttribute("data-latitude", oldtr.getAttribute('data-latitude'));
          tr.setAttribute("data-longitude", oldtr.getAttribute('data-longitude'));
          tr.setAttribute("data-setype", oldtr.getAttribute('data-setype'));
          tr.setAttribute("data-modulelabel", oldtr.getAttribute('data-modulelabel'));
          tr.setAttribute("data-ctroutepriority", oldtr.getAttribute('data-ctroutepriority'));
          tr.setAttribute("draggable","true");
          let td1 = document.createElement('td');
          let td2 = document.createElement('td');
          let td3 = document.createElement('td');
          let td4 = document.createElement('td');
          let td5 = document.createElement('td');
          let td6 = document.createElement('td');
          var sr_no = i+1;
          td1.innerHTML = '<span class="sr_no">'+sr_no+'</span>';
          td2.textContent = oldtr.getAttribute('data-modulelabel');
          td3.textContent = oldtr.getAttribute('data-label');
          td4.textContent = oldtr.getAttribute('data-address');
          //td5.textContent = oldtr.getAttribute('data-ctroutepriority');
          td5.innerHTML = '<span class="ctrouteprioritytext">'+oldtr.getAttribute('data-ctroutepriority')+'</span>'+priorityHtml.wrap('<div></div>').parent().html()+'<div class="input-save-wrap hide"><span class="pointerCursorOnHover input-group-addon input-group-addon-save inlineAjaxSave"><i class="fa fa-check"></i></span><span class="pointerCursorOnHover input-group-addon input-group-addon-cancel inlineAjaxCancel"><i class="fa fa-close"></i></span></div>';
          td6.innerHTML = "<span class='more dropdown action'><span href='javascript:;' class='dropdown-toggle' data-toggle='dropdown' aria-expanded='false' style='cursor:pointer;'><i class='fa fa-ellipsis-v icon'></i></span><ul class='dropdown-menu'><li><a class='deleteStops' onclick='deleteStops(this)' title='Delete'>Delete</a></li><li><a class='changePriority' onclick='changePriority(this)' title='Delete'>Change Priority</a></li></ul></span>";
          tr.append(td1);
          tr.append(td2);
          tr.append(td3);
          tr.append(td4);
          tr.append(td5);
          tr.append(td6);
          document.querySelector('#example1 tbody').append(tr);
          var stoplength = jQuery('#example1 tbody').find('tr').length;
          jQuery('#stops_count').text(stoplength);
          $('#popupModal').modal('toggle');
          reArrangeSequence();
        }
      }
    });

    jQuery('[name="sourceModule"]').on('change',function(){
      var sourceModule = jQuery(this).val();
      var params = {};
      params['module'] = 'CTMobileSettings';
      params['view'] = 'RoutePlanning';
      params['mode'] = 'getModuleFields';
      params['sourceModule'] = sourceModule;
      AppConnector.request(params).then(function(data) {
          jQuery('.modulecontainer').html(data.result);
          app.changeSelectElementView(popupPageContainer);
          //register all select2 Elements
          app.showSelect2ElementView(popupPageContainer.find('select.select2'));
      });
    });
    popupPageContainer.find('#search-input').on('keyup',function(e){
      //console.log(e.keyCode);
      
      /*if (e.keyCode == 13) {*/

          hideSearchResults();
          clearSearchResults();
          clearSearchData();
          var modulename = popupPageContainer.find('[name="sourceModule"]').val();
          var searchvalue = jQuery(this).val();
          var searchField = jQuery('[name="moduleField"]').val();
          if(searchvalue.length >= 3){
              var params = {};
              var crmids = [];
              jQuery('#stoptable tr').each(function(index){
                  var crmid = jQuery(this).data('crmid');
                  if (crmid) {
                    crmids.push(crmid);
                  }
              });

              params['module'] = 'CTMobileSettings';
              params['view'] = 'RoutePlanning';
              params['mode'] = 'getRecordbySearch';
              params['modulename'] = modulename;
              params['searchvalue'] = searchvalue;
              params['searchField'] = searchField;
              params['crmids'] = crmids;
              app.helper.showProgress();

              AppConnector.request(params).then(function(data) {
                  var searchResult = data.result;
                  clearSearchResults();
                  if(searchResult.length == 0){
                    document.getElementById("search-results").innerHTML = "<div class='search-item'><p>"+app.vtranslate('JS_NO_RESULTS_FOUND')+"</p><p><a id='create_Record'>"+app.vtranslate('Create Record')+"</a></p></div>";
                    displaySearchResults();
                  }else{
                    jQuery.each(searchResult,function(index,value){
                      //console.log(value);
                      //console.log(value.label);

                      document.getElementById("search-results").innerHTML +=
                      "<div class='search-item' data-crmid='"+value.crmid +"' data-label='"+value.label+"' data-address='"+value.address+"' data-latitude='"+value.latitude+"' data-longitude='"+value.longitude+"' data-setype='"+value.setype+"' data-modulelabel='"+value.modulelabel+"' onclick='displayData(this)'><p>" +value.label +"</p></div>";
                    });
                    displaySearchResults();
                  }
                  app.helper.hideProgress();
                  //jQuery('#search-input').val('');
              });
          }

        /*}*/
    });

    //shortens document.getEgetElementById
function element(id) {
return document.getElementById(id);
}

function clearSearchData() {
element("search-data").innerHTML = "";
}

function hideSearchResults() {
element("search-results").style.display = "none";
}

function clearSearchResults() {
element("search-results").innerHTML = "";
}

function displaySearchResults() {
element("search-results").style.display = "block";
}

function displayData(event) {
  var ctrouteprioriry = jQuery('[name="routepriority"]').val();
  let tr = document.createElement('tr');
  tr.setAttribute("data-crmid", event.getAttribute('data-crmid'));
  tr.setAttribute("data-label", event.getAttribute('data-label'));
  tr.setAttribute("data-address", event.getAttribute('data-address'));
  tr.setAttribute("data-latitude", event.getAttribute('data-latitude'));
  tr.setAttribute("data-longitude", event.getAttribute('data-longitude'));
  tr.setAttribute("data-setype", event.getAttribute('data-setype'));
  tr.setAttribute("data-modulelabel", event.getAttribute('data-modulelabel'));
  tr.setAttribute("data-ctroutepriority", ctrouteprioriry);
  let td1 = document.createElement('td');
  let td2 = document.createElement('td');
  let td3 = document.createElement('td');
  let td4 = document.createElement('td');
  td1.textContent = event.getAttribute('data-label');
  td2.textContent = event.getAttribute('data-address');
  td3.textContent = ctrouteprioriry;
  td4.innerHTML = "<a class='btn btn-danger deleteStops' onclick='deleteStops(this)' title='Delete'><i class='fa fa-trash'></i></a>";
  tr.append(td1);
  tr.append(td2);
  tr.append(td3);
  tr.append(td4);
  //element("search-data").innerHTML = "<p>" + event.getAttribute('data-label') + "</p>";
  //var child = "<tr><td>"+  +"</td><td>"+ event.getAttribute('data-address') +"</td><td></td></tr>";
  document.querySelector('#stoptable tbody').append(tr); 
  hideSearchResults();
  jQuery('#search-input').val('');
}
</script>
{/literal}