/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is: vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/

Vtiger_List_Js("CTTimeTracker_List_Js", {}, {
    
    registerDownloadEvent : function() {
        jQuery('#myModal').on('click','#exportsummary',function(){
            var params = {
                module: 'CTTimeTracker',
                action: 'getTracking',
                mode: 'ExportDataCount'
            };
            app.helper.showProgress();
            app.request.post({data: params}).then(function (err, res) {
                app.helper.hideProgress();
                if(res['success'] > 0){
                    jQuery('#myModal').find('#exporttype').val('exportsummary');
                    jQuery('#downloadForm').submit();
                }else{
                    app.helper.showSuccessNotification({message: app.vtranslate('No Data Available.')});
                       
                }
            
            });  
            
        });

        jQuery('#myModal').on('click','#exportwithdetails',function(){
             var params = {
                module: 'CTTimeTracker',
                action: 'getTracking',
                mode: 'ExportDataCount'
            };
            app.helper.showProgress();
            app.request.post({data: params}).then(function (err, res) {
                app.helper.hideProgress();
                if(res['success'] > 0){
                    jQuery('#myModal').find('#exporttype').val('exportwithdetails');
                    jQuery('#downloadForm').submit();
                }else{
                    app.helper.showSuccessNotification({message: app.vtranslate('No Data Available.')});
                       
                }
            
            }); 
        });
    },
    
    registerEvents: function() {
        this.registerDownloadEvent();
    }
});