<?php
/*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */
include_once dirname(__FILE__) . '/FetchRecordWithGrouping.php';

include_once 'include/Webservices/Create.php';
include_once 'include/Webservices/Update.php';

class CTMobile_WS_SaveAjaxRecord extends CTMobile_WS_FetchRecordWithGrouping {
	protected $recordValues = false;
	
	// Avoid retrieve and return the value obtained after Create or Update
	protected function processRetrieve(CTMobile_API_Request $request) {
		return $this->recordValues;
	}
	
	function process(CTMobile_API_Request $request) {
		global $current_user; // Required for vtws_update API
		$current_user = $this->getActiveUser();
		$refrenceUitypes = array(10,51,57,58,59,66,73,75,76,78,80,81,101);
		$module = trim($request->get('module'));
		$isCalendar = trim($request->get('isCalendar'));
		if($module == ''){
			$message = $this->CTTranslate('Required fields not found');
			throw new WebServiceException(404,$message);
		}

		//start validation for module & fields
		if(!getTabid($module)){
			$message = vtranslate($module,$module)." ".$this->CTTranslate('Module does not exists');
			throw new WebServiceException(404,$message);
		}
		
		$recordid = trim($request->get('record'));
		$valuesJSONString =  $request->get('values');

		$values = "";
		if(!empty($valuesJSONString) && is_string($valuesJSONString)) {
			$values = Zend_Json::decode($valuesJSONString);
		} else {
			$values = $valuesJSONString; // Either empty or already decoded.
		}

		$response = new CTMobile_API_Response();
		
		if (empty($values)) {
			$message =  $this->CTTranslate('Values cannot be empty');
			$response->setError(404, $message);
			return $response;
		}

		$arrRecordId = explode('x',$recordid);
		if($module == 'Events'){
			$moduleName = 'Calendar';
		}else{
			$moduleName = $module;
		}
		$actionName = 'EditView';
		if(!Users_Privileges_Model::isPermitted($moduleName, $actionName, $arrRecordId[1])) {
			throw new AppException(vtranslate('LBL_PERMISSION_DENIED'));
		}

		try {
			// Retrieve or Initalize
			if (!empty($recordid)) {
				if(in_array($module, array('Quotes','Invoice','SalesOrder','PurchaseOrder'))){
					$_REQUEST['action'] = 'SaveAjax';
				}
				$mode = 'edit';
				$arrRecordId = explode('x',$recordid);
				$recordModel = Vtiger_Record_Model::getInstanceById($arrRecordId[1], $module);
				$recordModel->set('id', $arrRecordId[1]);
				$recordModel->set('mode', 'edit');
				
				$moduleModel = Vtiger_Module_Model::getInstance($module);
				$fieldModelList = $moduleModel->getFields();
				foreach ($fieldModelList as $fieldName => $fieldModel) {
					if($fieldName != 'invite_user' || $fieldName != 'LineItems'){
						if(key_exists($fieldName,$values)){
							$fieldValue = $values[$fieldName];
							$uitype = $fieldModel->get('uitype');
							$fieldDataType = $fieldModel->getFieldDataType();
							if(in_array($uitype,array(10,51,53,57,58,59,66,73,75,76,78,80,81,101))){
								if($fieldValue != ''){
									$tmp_value = explode('x',$fieldValue);
									$fieldValue = $tmp_value[1];
								}
							}
							if($fieldName == 'assigned_user_id1'){
								if($fieldValue != ''){
									$tmp_value = explode('x',$fieldValue);
									$fieldValue = $tmp_value[1];
								}
							}
							if($fieldDataType == 'time'){
								$fieldValue = Vtiger_Time_UIType::getTimeValueWithSeconds($fieldValue);
							}else if($fieldName == 'currency_id' && $module == 'PriceBooks'){
								if($fieldValue != ''){
									$fvalue = explode('x', $fieldValue);
									$fieldValue =  $fvalue[1];
								}
							}else if($fieldDataType == 'picklist' && $fieldValue == ""){
								$fieldValue = " ";
							}
							if($fieldValue !== null) {
								if(!is_array($fieldValue) && $fieldDataType != 'currency') {
									if($fieldValue != " "){
										$fieldValue = trim($fieldValue);
									}
								}
								$recordModel->set($fieldName, $fieldValue);
							}
						}
					}
				}
				
				if($module == 'Calendar' && in_array('eventstatus',array_keys($values))) {
					$recordModel->set('taskstatus',$values['eventstatus']);
				}
				$recordModel->save();
				$moduleWSId = CTMobile_WS_Utils::getEntityModuleWSId($module);
				$lastInsertId = $recordModel->getId();
				$lastInsertWSId= $moduleWSId.'x'.$lastInsertId;
				
			}

			// Update the record id
			$request->set('record', $lastInsertWSId);
			
			if($request->get('user_lat')!='' && $request->get('user_long')!='' && $request->get('user_id')!=''){
				
				if($lastInsertWSId!=''){
					global $adb;
					$date_var = date("Y-m-d H:i:s");
					$userId = explode('x', $request->get('user_id'));
					$recordId = explode('x', $lastInsertWSId);
					$createdtime = $adb->formatDate($date_var, true);
					$query = $adb->pquery("INSERT INTO ctmobile_userderoute (userid, latitude, longitude, createdtime,action,record) VALUES (?,?,?,?,?,?)", array($userId[1], $request->get('user_lat'), $request->get('user_long'), $createdtime,$mode,$recordId[1]));
					
				}
				
			}
			$message = $this->CTTranslate('Record save successfully');
			if($isCalendar == "1" && $module == 'Events'){
				$isShowCheckin = true;
				if($recordModel->get('eventstatus') == 'Held'){
					$isShowCheckin = false;
				}
				$result = array('id'=>$lastInsertWSId,'module'=>$module,'message'=>$message,'isShowCheckin'=>$isShowCheckin);
			}else if($isCalendar == "1" && $module == 'Calendar'){
				$isShowCheckin = false;
				$result = array('id'=>$lastInsertWSId,'module'=>$module,'message'=>$message,'isShowCheckin'=>$isShowCheckin);
			}else{
				$result = array('id'=>$lastInsertWSId,'module'=>$module,'message'=>$message);
			}
			$response->setResult($result);
			
			
		} catch(Exception $e) {
			$response->setError($e->getCode(), $e->getMessage());
		}
		return $response;
	}
	
}
