<?php
/*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */

class CTMobile_WS_SaveSearchField extends CTMobile_WS_Controller {
	
    function process(CTMobile_API_Request $request) {
	    global $adb,$current_user;
	    $current_user = $this->getActiveUser();

	    $module=$request->get("module");
        $userid = $request->get("userid");
        $search_field=$request->get("search_field");

        if($module && $userid && $search_field){
            // Clear data
            $adb->pquery("DELETE FROM `ctmobile_search_field` WHERE `module`=? AND userid = ?",array($module,$userid));

            $moduleModel = Vtiger_Module_Model::getInstance($module);
            $fieldModels = $moduleModel->getFields();
            $fieldCustomViewName = $fieldModels[$search_field]->getCustomViewColumnName();
            // Save selected fields
            $adb->pquery("INSERT INTO `ctmobile_search_field` (`module`,`fieldname`,`userid`) VALUES (?,?,?)",array($module,$fieldCustomViewName,$userid));
        }else{
            $message =  $this->CTTranslate('Required fields not found');
            throw new WebServiceException(404,$message);
        }

        $response = new CTMobile_API_Response();
        $message = $this->CTTranslate('Search Field save successfully');
        $response->setResult(array("message"=>$message));
        return $response;

    }

}