<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/

class Grupaje_Record_Model extends Vtiger_Record_Model {

	public function calcularValorFinalFCA()
    {

        global $adb;

        $q = $adb->pquery("SELECT e.crmid as id FROM vtiger_crmentityrel e 
                            INNER JOIN vtiger_crmentity c ON c.crmid = e.crmid
                            WHERE e.module = 'Quotes' 
                            AND e.relmodule = 'Grupaje' 
                            AND e.relcrmid = ? AND c.deleted = 0
                            UNION ALL select e2.relcrmid as id  FROM vtiger_crmentityrel e2
                    INNER JOIN vtiger_crmentity c2 ON c2.crmid = e2.relcrmid
                    WHERE e2.module = 'Grupaje' AND e2.relmodule = 'Quotes' AND c2.deleted = 0 AND e2.crmid = ?",[$this->getId(), $this->getId()]);
        $total = 0;
        if($adb->num_rows($q) > 0) {
            for ($i=0; $i < $adb->num_rows($q); $i++) { 
                $id = $adb->query_result($q, $i, 'id');
                $recordModel = Vtiger_Record_Model::getInstanceById($id, 'Quotes');
                $total += $recordModel->get('hdnGrandTotal');
            }
        }
        $adb->pquery("UPDATE vtiger_grupaje SET valorfinal_fca = ? WHERE grupajeid = ?", array($total, $this->getId()));


        $GrupajeRecordModel = Vtiger_Record_Model::getInstanceById($this->getId(), 'Grupaje');
        $GrupajeRecordModel->set('mode','edit');
        $GrupajeRecordModel->save();
    }

    /**
	  * Function to get the send email pdf url
	  * @return <string>
	  */
	public function getSendEmailPDFUrl() {
		return 'module='.$this->getModuleName().'&view=SendEmail&mode=composeMailData&record='.$this->getId();
	}

    public function getMassQuoteFiles() {
        global $adb;

        /*Obtiene todas las cotizaciones asociadas al grupaje */
        $query = "SELECT q.quoteid, q.quote_no  FROM vtiger_quotes q
            INNER JOIN vtiger_crmentity ce ON ce.crmid = q.quoteid
            WHERE ce.deleted = 0 AND q.grupajeid = ?";
        
        $result = $adb->pquery($query, array($this->getId()));
        
        if(!empty($adb->num_rows($result))) {
            for($i=0; $i<$adb->num_rows($result); $i++) {
                #$adb->setDebug(1);
                $q = $adb->pquery("SELECT n.notesid, a.attachmentsid FROM vtiger_senotesrel r 
                    JOIN vtiger_notes n ON r.notesid = n.notesid
                    INNER JOIN vtiger_crmentity ce ON ce.crmid = n.notesid
                    JOIN vtiger_seattachmentsrel a ON a.crmid = n.notesid
                    INNER JOIN vtiger_crmentity ce2 ON ce2.crmid = a.attachmentsid AND ce2.deleted = 0
                    WHERE ce.deleted = 0 AND n.incluir_correo_grupaje = 'Si' AND r.crmid = ?", array($adb->query_result($result, $i, 'quoteid')));
                #$adb->setDebug(0);
                #debug($adb->num_rows($q));
                if(!empty($adb->num_rows($q))) {
                    for ($i2=0; $i2 < $adb->num_rows($q); $i2++) { 
                        $attachmentsid = $adb->query_result($q, $i2, 'attachmentsid');
                        $q1 = $adb->pquery("SELECT * FROM vtiger_attachments WHERE attachmentsid = ?", array($attachmentsid));
                        if(!empty($adb->num_rows($q1))) {
                            $fileDetails[] = array(
                                'name' => $adb->query_result($q1, 0, 'name'),
                                'type' => $adb->query_result($q1, 0, 'type'),
                                'path' => $adb->query_result($q1, 0, 'path'),
                                'storedname' => $adb->query_result($q1, 0, 'storedname'),
                                'attachmentsid' => $adb->query_result($q1, 0, 'attachmentsid'),
                                'docid' =>  $adb->query_result($q1, 0, 'attachmentsid'),
                                'quote_no' => $adb->query_result($result, $i, 'quote_no'),
                            );
                        }
                    }
                }else{
                    $fileDetails[] = array(
                        'quote_no' => $adb->query_result($result, $i, 'quote_no'),
                        'name' => null
                    );
                }
            }
        }

        return $fileDetails;
    }
}
