<?php

class Quotes_addQuoteToGrupaje_Action extends Vtiger_Action_Controller {
    
    function __construct() {
        parent::__construct();
        $this->exposeMethod('processGrupaje');
    }
    
    function checkPermission(Vtiger_Request $request) {
        $moduleName = $request->getModule();
        $userPrivilegesModel = Users_Privileges_Model::getCurrentUserPrivilegesModel();
        $permission = $userPrivilegesModel->hasModulePermission(getTabid($moduleName));
        
        if (!$permission) {
            throw new AppException(vtranslate('LBL_PERMISSION_DENIED'));
        }
    }
    
    function process(Vtiger_Request $request) {
        global $adb;
        
        // Obtener información del registro relacionado seleccionado en el popup
        $relatedRecordId = $request->get('related_record_id')['info']['grupajeid'];
        $relatedModule = $request->get('related_module');
        #debug($relatedRecordId);
        // Obtener los IDs de los quotes seleccionados
        $selectedIds = $this->getRecordsListFromRequest($request);

        try {
            // Aquí implementa la lógica específica para agrupar los quotes
            // Por ejemplo, actualizar un campo de agrupación en cada quote seleccionado
            
            if (is_array($selectedIds)) {
                $proccesed = 0;
                foreach ($selectedIds as $quoteId) {
                    //Verifica que la cotización se encuentre en estado "Ordered"
                    $q1 = $adb->pquery("SELECT 1 FROM vtiger_quotescf WHERE quoteid = ? AND cf_931 = 'Ordered'", array($quoteId));
                    if (!empty($adb->num_rows($q1))) {
                        $proccesed++;
                        $q = $adb->pquery("SELECT 1 FROM vtiger_crmentityrel e 
                                            INNER JOIN vtiger_crmentity c ON c.crmid = e.crmid
                                            WHERE e.module = 'Quotes' AND e.relmodule = 'Grupaje' AND e.relcrmid = ? AND c.deleted = 0 AND e.crmid = ?
                                            UNION ALL select 1 FROM vtiger_crmentityrel e2
                                            INNER JOIN vtiger_crmentity c2 ON c2.crmid = e2.relcrmid
                                            WHERE e2.module = 'Grupaje' AND e2.relmodule = 'Quotes' AND e2.relcrmid = ? AND c2.deleted = 0 AND e2.crmid = ?", 
                                            array($relatedRecordId, $quoteId,$quoteId, $relatedRecordId));
                                            
                        if ($adb->num_rows($q) > 0) {
                            $adb->pquery("DELETE FROM vtiger_crmentityrel WHERE module = 'Quotes' AND relmodule = 'Grupaje' AND relcrmid = ? AND crmid = ?", array($relatedRecordId, $quoteId));
                            $adb->pquery("DELETE FROM vtiger_crmentityrel WHERE module = 'Grupaje' AND relmodule = 'Quotes' AND relcrmid = ? AND crmid = ?", array($quoteId, $relatedRecordId));
                            $adb->pquery("UPDATE vtiger_quotes SET grupajeid = NULL WHERE quoteid = ?", array($quoteId));
                        }

                        $adb->pquery("INSERT INTO vtiger_crmentityrel (crmid, module, relcrmid, relmodule) VALUES (?, 'Quotes', ?, 'Grupaje')", array($quoteId, $relatedRecordId));
                        $adb->pquery("UPDATE vtiger_quotes SET grupajeid = ? WHERE quoteid = ?", array($relatedRecordId, $quoteId));
                    }
                }
            }
            
            $recordModel = Vtiger_Record_Model::getInstanceById($relatedRecordId, $relatedModule);
            $recordModel->calcularValorFinalFCA();
            // Construir la respuesta
            $result = array(
                'success' => true,
                'message' => $proccesed.' Cotizaciones en estado "Ordered" agregados de '.count($selectedIds).' seleccionados',
                'count' => count($proccesed)
            );
            
            $response = new Vtiger_Response();
            $response->setResult($result);
            $response->emit();
            
        } catch (Exception $e) {
            $response = new Vtiger_Response();
            $response->setError($e->getCode(), $e->getMessage());
            $response->emit();
        }
    }

    /**
	 * Function returns the record Ids selected in the current filter
	 * @param Vtiger_Request $request
	 * @return integer
	 */
	function getRecordsListFromRequest(Vtiger_Request $request, $module = false) {
		$cvId = $request->get('viewname');
		$selectedIds = $request->get('selected_ids');
		$excludedIds = $request->get('excluded_ids');
        if(empty($module)) {
            $module = $request->getModule();
        }
		if(!empty($selectedIds) && $selectedIds != 'all') {
			if(!empty($selectedIds) && php7_count($selectedIds) > 0) {
				return $selectedIds;
			}
		}
        $tagParams = $request->get('tag_params');
		$tag = $request->get('tag');
		$listViewSessionKey = $module.'_'.$cvId;

		if(!empty($tag)) {
			$listViewSessionKey .='_'.$tag;
		}

		$orderParams = Vtiger_ListView_Model::getSortParamsSession($listViewSessionKey);
		if(!empty($tag) && empty($tagParams)){
			$tagParams = $orderParams['tag_params'];
		}

		if(empty($tagParams)){
			$tagParams = array();
		}
		$searchParams = $request->get('search_params');
		if(empty($searchParams) && !is_array($searchParams)){
			$searchParams = array();
		}
		$searchAndTagParams = array_merge($searchParams, $tagParams);
		
		$sourceRecord = $request->get('sourceRecord');
		$sourceModule = $request->get('sourceModule');
		if ($sourceRecord && $sourceModule) {
			$sourceRecordModel = Vtiger_Record_Model::getInstanceById($sourceRecord, $sourceModule);
			return $sourceRecordModel->getSelectedIdsList($module, $excludedIds);
		}

		$customViewModel = CustomView_Record_Model::getInstanceById($cvId);
		if($customViewModel) {
			$searchKey = $request->get('search_key');
			$searchValue = $request->get('search_value');
			$operator = $request->get('operator');
			if(!empty($operator)) {
				$customViewModel->set('operator', $operator);
				$customViewModel->set('search_key', $searchKey);
				$customViewModel->set('search_value', $searchValue);
			}
            $customViewModel->set('search_params', $searchAndTagParams);
			return $customViewModel->getRecordIds($excludedIds,$module);
		}
	}

}