<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/

class Vtiger_SaveAjax_Action extends Vtiger_Save_Action {

	public function process(Vtiger_Request $request) {
		global $adb;
		$fieldToBeSaved = $request->get('field');
		$response = new Vtiger_Response();
		try {
			vglobal('VTIGER_TIMESTAMP_NO_CHANGE_MODE', $request->get('_timeStampNoChangeMode',false));
			$recordModel = $this->saveRecord($request);
			vglobal('VTIGER_TIMESTAMP_NO_CHANGE_MODE', false);

			$fieldModelList = $recordModel->getModule()->getFields();
			$result = array();
			$picklistColorMap = array();
			foreach ($fieldModelList as $fieldName => $fieldModel) {
				if($fieldModel->isViewable()){
					$recordFieldValue = $recordModel->get($fieldName);
					if(is_array($recordFieldValue) && $fieldModel->getFieldDataType() == 'multipicklist') {
						foreach ($recordFieldValue as $picklistValue) {
							$picklistColorMap[$picklistValue] = Settings_Picklist_Module_Model::getPicklistColorByValue($fieldName, $picklistValue);
						}
						$recordFieldValue = implode(' |##| ', $recordFieldValue);     
					}
					if($fieldModel->getFieldDataType() == 'picklist') {
						$picklistColorMap[$recordFieldValue] = Settings_Picklist_Module_Model::getPicklistColorByValue($fieldName, $recordFieldValue);
					}
					$fieldValue = $displayValue = Vtiger_Util_Helper::toSafeHTML($recordFieldValue);
					if ($fieldModel->getFieldDataType() !== 'currency' && $fieldModel->getFieldDataType() !== 'datetime' && $fieldModel->getFieldDataType() !== 'date' && $fieldModel->getFieldDataType() !== 'double') { 
						$displayValue = $fieldModel->getDisplayValue($fieldValue, $recordModel->getId()); 
					}
					if ($fieldModel->getFieldDataType() == 'currency') {
						$displayValue = Vtiger_Currency_UIType::transformDisplayValue($fieldValue);
					}
					if(!empty($picklistColorMap)) {
						$result[$fieldName] = array('value' => $fieldValue, 'display_value' => $displayValue, 'colormap' => $picklistColorMap);
					} else {
						$result[$fieldName] = array('value' => $fieldValue, 'display_value' => $displayValue);
					}
				}
			}

			//Handling salutation type
			if ($request->get('field') === 'firstname' && in_array($request->getModule(), array('Contacts', 'Leads'))) {
				$salutationType = $recordModel->getDisplayValue('salutationtype');
				$firstNameDetails = $result['firstname'];
				$firstNameDetails['display_value'] = $salutationType. " " .$firstNameDetails['display_value'];
				if ($salutationType != '--None--') $result['firstname'] = $firstNameDetails;
			}

			// removed decode_html to eliminate XSS vulnerability
			$result['_recordLabel'] = decode_html($recordModel->getName());
			$result['_recordId'] = $recordModel->getId();

			$param = $request->get('lt_selectedrecord');
			
			if(!empty($param)){
				$arr = array(
					'module' => 'Quotes',
					'viewname' => $param['viewname'],
					'selected_ids' => $param['selected_ids'],
					'excluded_ids' => $param['excluded_ids'],
					'search_params' => $param['search_params'],
	
				);
				$request2 = new Vtiger_Request($arr);
	
				$recordIds = $this->getRecordsListFromRequest($request2);
				
				if($request->get('module') == 'Grupaje' && !empty($recordIds))
				{
					foreach($recordIds as $recordId)
					{
						//Verifica que la cotización se encuentre en estado "Ordered"
						$q1 = $adb->pquery("SELECT 1 FROM vtiger_quotescf WHERE quoteid = ? AND cf_931 = 'Ordered'", array($recordId));
						if (!empty($adb->num_rows($q1))) {
							#Revisa que el ID no esté asociado a una grupaje
							$q = $adb->pquery("SELECT 1 FROM vtiger_crmentityrel e 
												INNER JOIN vtiger_crmentity c ON c.crmid = e.crmid
												WHERE e.module = 'Quotes' AND e.relmodule = 'Grupaje' AND e.relcrmid = ? AND c.deleted = 0 AND e.crmid = ?
												UNION ALL select 1 FROM vtiger_crmentityrel e2
												INNER JOIN vtiger_crmentity c2 ON c2.crmid = e2.relcrmid
												WHERE e2.module = 'Grupaje' AND e2.relmodule = 'Quotes' AND e2.relcrmid = ? AND c2.deleted = 0 AND e2.crmid = ?", 
												array($recordModel->getId(), $recordId,$recordId, $recordModel->getId()));

							if ($adb->num_rows($q) > 0) {
								$adb->pquery("DELETE FROM vtiger_crmentityrel WHERE module = 'Quotes' AND relmodule = 'Grupaje' AND crmid = ?", array($record));
								$adb->pquery("DELETE FROM vtiger_crmentityrel WHERE module = 'Grupaje' AND relmodule = 'Quotes' AND relcrmid = ?", array($record));
							}

							$adb->pquery("INSERT INTO vtiger_crmentityrel (crmid, module, relcrmid, relmodule) VALUES (?, 'Quotes', ?, 'Grupaje')", array($recordId, $recordModel->getId()));
							$adb->pquery("UPDATE vtiger_quotes SET grupajeid = ? WHERE quoteid = ?", array( $recordModel->getId(), $recordId));

						}
					}

					$recordModel->calcularValorFinalFCA();
				}
			}

			if($_POST['module'] == 'Quotes' && $_POST['action'] == 'SaveAjax')
			{
				$grupajeId = $request->get('grupajeid');
				if(!empty($grupajeId))
				{
					$record = $request->get('record');
					$adb->pquery("DELETE FROM vtiger_crmentityrel WHERE module = 'Quotes' AND relmodule = 'Grupaje' AND crmid = ?", array($record));
					$adb->pquery("DELETE FROM vtiger_crmentityrel WHERE module = 'Grupaje' AND relmodule = 'Quotes' AND relcrmid = ?", array($record));
					$adb->pquery("INSERT INTO vtiger_crmentityrel (crmid, module, relcrmid, relmodule) VALUES (?, 'Quotes', ?, 'Grupaje')", array($record, $grupajeId));
					
					$grupajeRecordModel = Vtiger_Record_Model::getInstanceById($grupajeId, 'Grupaje');
					$grupajeRecordModel->calcularValorFinalFCA();
				}
				
			}
			

			$response->setEmitType(Vtiger_Response::$EMIT_JSON);
			$response->setResult($result);
		} catch (DuplicateException $e) {
			$response->setError($e->getMessage(), $e->getDuplicationMessage(), $e->getMessage());
		} catch (Exception $e) {
			$response->setError($e->getMessage());
		}
		$response->emit();
	}

	/**
	 * Function to get the record model based on the request parameters
	 * @param Vtiger_Request $request
	 * @return Vtiger_Record_Model or Module specific Record Model instance
	 */
	public function getRecordModelFromRequest(Vtiger_Request $request) {
		$moduleName = $request->getModule();
		if($moduleName == 'Calendar') {
			$moduleName = $request->get('calendarModule');
		}
		$recordId = $request->get('record');

		if(!empty($recordId)) {
			$recordModel = Vtiger_Record_Model::getInstanceById($recordId, $moduleName);
			$recordModel->set('id', $recordId);
			$recordModel->set('mode', 'edit');

			$fieldModelList = $recordModel->getModule()->getFields();
			foreach ($fieldModelList as $fieldName => $fieldModel) {
				//For not converting createdtime and modified time to user format
				$uiType = $fieldModel->get('uitype');
				if ($uiType == 70) {
					$fieldValue = $recordModel->get($fieldName);
				} else {
					$fieldValue = $fieldModel->getUITypeModel()->getUserRequestValue($recordModel->get($fieldName));
				}

				// To support Inline Edit in Vtiger7
				if($request->has($fieldName)){
					$fieldValue = $request->get($fieldName,null);
				}else if($fieldName === $request->get('field')){
					$fieldValue = $request->get('value');
				}
				$fieldDataType = $fieldModel->getFieldDataType();
				if ($fieldDataType == 'time' && $fieldValue !== null) {
					$fieldValue = Vtiger_Time_UIType::getTimeValueWithSeconds($fieldValue);
				}
                $fieldValue = $this->purifyCkeditorField($fieldName, $fieldValue);
				if ($fieldValue !== null) {
					if (!is_array($fieldValue)) {
						$fieldValue = trim($fieldValue);
					}
					$recordModel->set($fieldName, $fieldValue);
				}
				$recordModel->set($fieldName, $fieldValue);
				if($fieldName === 'contact_id' && isRecordExists($fieldValue)) {
					$contactRecord = Vtiger_Record_Model::getInstanceById($fieldValue, 'Contacts');
					$recordModel->set("relatedContact",$contactRecord);
				}
			}
		} else {
			$moduleModel = Vtiger_Module_Model::getInstance($moduleName);

			$recordModel = Vtiger_Record_Model::getCleanInstance($moduleName);
			$recordModel->set('mode', '');

			$fieldModelList = $moduleModel->getFields();
			foreach ($fieldModelList as $fieldName => $fieldModel) {
				if ($request->has($fieldName)) {
					$fieldValue = $request->get($fieldName, null);
				} else {
					$fieldValue = $fieldModel->getDefaultFieldValue();
				}
                if($fieldValue){
                    $fieldValue = Vtiger_Util_Helper::validateFieldValue($fieldValue,$fieldModel);
                }
				$fieldDataType = $fieldModel->getFieldDataType();
				if ($fieldDataType == 'time' && $fieldValue !== null) {
					$fieldValue = Vtiger_Time_UIType::getTimeValueWithSeconds($fieldValue);
				}
                $fieldValue = $this->purifyCkeditorField($fieldName, $fieldValue);
				if ($fieldValue !== null) {
					if (!is_array($fieldValue)) {
						$fieldValue = trim($fieldValue);
					}
					$recordModel->set($fieldName, $fieldValue);
				}
			} 
		}

		return $recordModel;
	}
    
    public function purifyCkeditorField($fieldName, $fieldValue) {
        $ckeditorFields = array('commentcontent', 'notecontent', 'signature');
        if((in_array($fieldName, $ckeditorFields)) && $fieldValue !== null){
            $purifiedContent = vtlib_purify(decode_html($fieldValue));
            // Purify malicious html event attributes
            $fieldValue = purifyHtmlEventAttributes(decode_html($purifiedContent),true);
        }
        return $fieldValue;
    }

	/**
	 * Function returns the record Ids selected in the current filter
	 * @param Vtiger_Request $request
	 * @return integer
	 */
	function getRecordsListFromRequest(Vtiger_Request $request, $module = false) {
		$cvId = $request->get('viewname');
		$selectedIds = $request->get('selected_ids');
		$excludedIds = $request->get('excluded_ids');
        if(empty($module)) {
            $module = $request->getModule();
        }
		if(!empty($selectedIds) && $selectedIds != 'all') {
			if(!empty($selectedIds) && php7_count($selectedIds) > 0) {
				return $selectedIds;
			}
		}
        $tagParams = $request->get('tag_params');
		$tag = $request->get('tag');
		$listViewSessionKey = $module.'_'.$cvId;

		if(!empty($tag)) {
			$listViewSessionKey .='_'.$tag;
		}

		$orderParams = Vtiger_ListView_Model::getSortParamsSession($listViewSessionKey);
		if(!empty($tag) && empty($tagParams)){
			$tagParams = $orderParams['tag_params'];
		}

		if(empty($tagParams)){
			$tagParams = array();
		}
		$searchParams = $request->get('search_params');
		if(empty($searchParams) && !is_array($searchParams)){
			$searchParams = array();
		}
		$searchAndTagParams = array_merge($searchParams, $tagParams);
		
		$sourceRecord = $request->get('sourceRecord');
		$sourceModule = $request->get('sourceModule');
		if ($sourceRecord && $sourceModule) {
			$sourceRecordModel = Vtiger_Record_Model::getInstanceById($sourceRecord, $sourceModule);
			return $sourceRecordModel->getSelectedIdsList($module, $excludedIds);
		}

		$customViewModel = CustomView_Record_Model::getInstanceById($cvId);
		if($customViewModel) {
			$searchKey = $request->get('search_key');
			$searchValue = $request->get('search_value');
			$operator = $request->get('operator');
			if(!empty($operator)) {
				$customViewModel->set('operator', $operator);
				$customViewModel->set('search_key', $searchKey);
				$customViewModel->set('search_value', $searchValue);
			}
            $customViewModel->set('search_params', $searchAndTagParams);
			return $customViewModel->getRecordIds($excludedIds,$module);
		}
	}
}
