function addCopyToClipboardEvent(selectors) {
	selectors.forEach(function (selector) {
		var elements = document.querySelectorAll(selector);

		if (elements.length === 0) {
			console.error("No se encontraron elementos con el selector: " + selector);
			return;
		}

		elements.forEach(function (element) {
			element.addEventListener('click', function () {
				var formattedValue = element.getAttribute('data-formatted-value');

				var tempElement = document.createElement('textarea');
				tempElement.value = formattedValue;
				document.body.appendChild(tempElement);

				tempElement.select();
				document.execCommand('copy');

				document.body.removeChild(tempElement);

				// Muestra la notificación de éxito específica para este elemento
				app.helper.showSuccessNotification({ message: 'Valor Copiado: ' + formattedValue });
			});
		});
	});
}





/**
 * Formatea un número con la cantidad de decimales y los separadores especificados.
 *
 * @param {number} number - El número a formatear.
 * @param {number} [decimales=0] - La cantidad de decimales a mostrar.
 * @param {string} [separatorMiles=','] - El separador de miles.
 * @param {string} [separatorDecimal='.'] - El separador decimal.
 * @returns {string} - El número formateado como cadena.
 */
function formatNumber(number, decimales = 0, separatorMiles = ',', separatorDecimal = '.') {
	// Validar que 'decimales' sea un número positivo
	if (typeof decimales !== 'number' || decimales < 0) {
		console.error("El parámetro 'decimales' debe ser un número positivo.");
		return number.toString(); // Devuelve la cadena original si 'decimales' no es válido.
	}

	// Convertir 'number' a un objeto Number.
	var numberObj = new Number(number);

	// Multiplicar por 10^decimales para preservar los decimales
	var factor = Math.pow(10, decimales);
	var roundedNumber = Math.round(numberObj * factor) / factor;

	// Convertir el número redondeado en una cadena con el número correcto de decimales
	var formattedNumber = roundedNumber.toFixed(decimales);

	// Aplicar separadores de miles a la parte entera del número.
	var parts = formattedNumber.split('.');
	parts[0] = parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, separatorMiles);

	// Unir las partes con el separador decimal adecuado
	var result = parts.join(separatorDecimal);
	// Verificar si el resultado es NaN después del formateo
	if (isNaN(parseFloat(result))) {
		//console.warn("El número después del formateo es NaN.");
		return number.toString(); // Devuelve la cadena original en caso de NaN.
	}

	// Devolver el resultado
	return result;
}





/**
 * Llena los campos de un formulario con datos de ubicación (ubigeo).
 *
 * @param {object} objubigeo - Objeto que contiene los valores de ubicación.
 * @param {object} objubigeo.pais - Objeto con información del país.
 * @param {string} objubigeo.pais.name - Nombre del campo de país.
 * @param {string} objubigeo.pais.value - Valor del país.
 * @param {object} objubigeo.departamento - Objeto con información del departamento.
 * @param {string} objubigeo.departamento.name - Nombre del campo de departamento.
 * @param {string} objubigeo.departamento.value - Valor del departamento.
 * @param {object} objubigeo.distrito - Objeto con información del distrito.
 * @param {string} objubigeo.distrito.name - Nombre del campo de distrito.
 * @param {string} objubigeo.distrito.value - Valor del distrito.
 * @param {object} objubigeo.provincia - Objeto con información de la provincia.
 * @param {string} objubigeo.provincia.name - Nombre del campo de provincia.
 * @param {string} objubigeo.provincia.value - Valor de la provincia.
 */
const Ubigeo_GetData = (objubigeo) => {
	let obj = {
		paisElemnt: select(`[name=${objubigeo.pais.name}]`),
		departamentoElemnt: select(`[name=${objubigeo.departamento.name}]`),
		distritoElemnt: select(`[name=${objubigeo.distrito.name}]`),
		provinciaElemnt: select(`[name=${objubigeo.provincia.name}]`),
	};
	if (obj.paisElemnt) obj.paisElemnt.value = objubigeo.pais.value;
	if (obj.departamentoElemnt) obj.departamentoElemnt.value = objubigeo.departamento.value;
	if (obj.distritoElemnt) obj.distritoElemnt.value = objubigeo.distrito.value;
	if (obj.provinciaElemnt) obj.provinciaElemnt.value = objubigeo.provincia.value;

	elementReadonly(true, obj.paisElemnt)
	elementReadonly(true, obj.departamentoElemnt)
	elementReadonly(true, obj.distritoElemnt)
	elementReadonly(true, obj.provinciaElemnt)
};



function FormatDobleAllView() {
	//console.log('FormatDobleAllView')
	let inputs = document.querySelectorAll('input[data-field]'); // Edit
	let spans = document.querySelectorAll('span[data-field-type="double"]');
	let tds = document.querySelectorAll('td[data-field-type="double"]');


	inputs.forEach(function (inputElement) {

		let dataField = JSON.parse(inputElement.dataset.field);
		if (dataField.type === "double") {
			let originalValue = inputElement.value.trim();

			//--- obtener configuracion del campo
			const miles = inputElement.getAttribute('data-group-separator', originalValue);
			const decimal = inputElement.getAttribute('data-number-of-decimal-places', originalValue);

			if (!miles && !decimal) return

			inputElement.value = formatNumber(originalValue, 2, miles, decimal);
			inputElement.setAttribute('data-value', originalValue);
		}
	});


	spans.forEach(function (span) {
		let originalValue = span.textContent.trim();
		//--- obtener configuracion del campo
		const miles = span.getAttribute('data-group-separator');
		const decimal = span.getAttribute('data-number-of-decimal-places');
		if (!miles && !decimal) return

		//console.log('span', span, miles, decimal)

		let formattedValue = formatNumber(originalValue, 2, miles, decimal);



		// Establecer el valor formateado como un atributo del td
		span.setAttribute('data-value', originalValue);
		span.textContent = formattedValue;
	});


	tds.forEach(function (td) {
		var originalValue = td.textContent.trim();

		const miles = td.getAttribute('data-group-separator', originalValue);
		const decimal = td.getAttribute('data-number-of-decimal-places', originalValue);
		if (!miles && !decimal) return
		let formattedValue = formatNumber(originalValue, 2, miles, decimal);

		// Establecer el valor formateado como un atributo del td
		td.setAttribute('data-value', originalValue);
		td.textContent = formattedValue;
	});
}



function FormatNumberAllView() {
	let inputs = document.querySelectorAll('input[data-field]'); // Edit
	let spans = document.querySelectorAll('span[data-field-type="integer"]');
	let tds = document.querySelectorAll('td[data-field-type="integer"]');

	inputs.forEach(function (inputElement) {
		let dataField = JSON.parse(inputElement.dataset.field)
		//console.log(inputElement, dataField.type)
		if (dataField.type === "integer") {
			let originalValue = inputElement.value.trim();
			inputElement.value = formatNumber(originalValue);
			inputElement.setAttribute('data-value', originalValue);
		}
	});

	spans.forEach(function (span) {
		var originalValue = span.textContent.trim();
		var formattedValue = formatNumber(originalValue);

		// Establecer el valor formateado como un atributo del td
		span.setAttribute('data-value', originalValue);
		span.textContent = formattedValue;
	});


	tds.forEach(function (td) {
		var originalValue = td.textContent.trim();
		var formattedValue = formatNumber(originalValue);

		// Establecer el valor formateado como un atributo del td
		td.setAttribute('data-value', originalValue);
		td.textContent = formattedValue;
	});
}
//------------------------./




function QuotesEdit_Init() {
	agregarBoton("Importar productos","div.fieldBlockContainer > div.row > div.col-sm-9.well > div ","buttonUploadProducts",["btn-success"],"modalUploadProducts()");
	agregarBoton("Descargar Formato","#buttonUploadProducts","buttonDownloadFormat",["btn-primary"],"downloadFormat()");
}

//Descargar el formato base
function downloadFormat(){
	const enlace = document.createElement('a');
	enlace.href = 'integraciones/FORMATO_IMPORTAR.xlsx';
	enlace.download = 'FORMATO_IMPORTAR.xlsx'; 
	document.body.appendChild(enlace); 
	enlace.click();
	document.body.removeChild(enlace); 
}

function modalUploadProducts() {

	let html = '';
	//console.log(formdata)
	app.helper.showProgress();

	html += `<form id="FormUploadExcel">`
	html += `<div class='row' style=" max-height: 500px; overflow: auto;">`

	html += `<div class='col-md-12'>`
	html += `<label>Subir archivo</label>`
	html += `<input type="file" name="excelFile" id="excelFile" accept=".xlsx"/>`
	html += `</div>`

	html += `</div>`
	html += `</form>`
	app.helper.showAlertBox({ message: app.vtranslate(html) });
	html = '';
	app.helper.hideProgress();
	addModalHeader('Importar productos', '')
	//agregarBoton('Continuar', '[data-bb-handler="ok"]', 'sendhandleok', ['btn-success'], `trigger_GetProducto(${id})`);
	agregarBoton('Continuar', '[data-bb-handler="ok"]', 'sendhandleok', ['btn-success'], `importDataQuotes()`);
}

//Logica para importar
function importDataQuotes(){
	app.helper.showProgress();

    const formData = new FormData(document.getElementById('FormUploadExcel'));
    //const progressBar = document.querySelector('.progress-bar');
    //const progressDiv = document.querySelector('.progress');
    //const statusDiv = document.getElementById('uploadStatus');

    //progressDiv.style.display = 'block';
    //statusDiv.innerHTML = 'Subiendo archivo...';

    fetch(`integraciones/Quotes/useCaseUploadExcelFile.php`, {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            // statusDiv.innerHTML = `<div class="alert alert-success">
            //     Archivo procesado correctamente
            //     <pre>${JSON.stringify(data.data, null, 2)}</pre>
            // </div>`;
			// html = "Se ha importado correctamente";
			// app.helper.showAlertNotification({'message':html});
			//console.log(data);//
			generateRowProducts(data);
        } else {
            throw new Error(data.message || 'Error al procesar el archivo');
        }
    })
    .catch(error => {
        // statusDiv.innerHTML = `<div class="alert alert-danger">
        //     Error: ${error.message}
        // </div>`;
    })
    .finally(() => {
		app.helper.hideProgress();
        //progressDiv.style.display = 'none';
    });
}

//Generar la filas y agregar contenido
function generateRowProducts(data){
	let dataColumns = data.data;
	console.log(dataColumns);
	
	// Get the current number of rows in the table
	let rowCounter = $("#lineItemTab .lineItemRow").length + 1;
	
	// Iterate through each row in the data using for loop
	//console.log(dataColumns.length);
	for(let i = 0; i < dataColumns.length; i++) {
		let row = dataColumns[i];
		console.log(row);
		
		// Verificar si ya existe una fila con el mismo nuevo_codigo
		let existingRowNumber = findExistingRowByCode(row);
		console.log(existingRowNumber);
		
		if (existingRowNumber) {
			// Actualizar la fila existente
			updateExistingRow(existingRowNumber, row);
			//console.log('Updated existing row:', row["producto_nombre"]);
		} else {
			// Crear nueva fila
			//$("#addProduct").trigger("click");
			document.getElementById("addProduct").click();
			$(`#productName${rowCounter}`).val(row["producto_nombre"]);
			$(`#hdnProductId${rowCounter}`).val(row["producto_id"]);
			$(`#codigo${rowCounter}`).val(row["codigo"]);
			$(`#nuevo_codigo${rowCounter}`).val(row["codigo_nuevo"]);
			$(`#comment${rowCounter}`).val(row["descripcion_aleman"]);
			$(`#comentario_es${rowCounter}`).val(row["descripcion_espanol"]);

			//Aplicar los descuentos
			if(row["descuento_porcentaje"] || row["descuento_directo"]){

				if(row["descuento_directo"]){
					//$(`input[name="discount${rowCounter}"]`).eq(2).prop('checked', true);
					document.querySelectorAll(`input[name="discount${rowCounter}"]`)[2].checked = true;
					$(`#discount_amount${rowCounter}`).val(row["descuento_directo"]);
				}else{
					//$(`input[name="discount${rowCounter}"]`).eq(1).prop('checked', true);
					document.querySelectorAll(`input[name="discount${rowCounter}"]`)[1].checked = true;
					$(`#discount_percentage${rowCounter}`).val(row["descuento_porcentaje"]);
				}
			}
			
			//$(`#listPrice${rowCounter}`).val(row["precio"]).focus().blur();
			let ePrice = document.getElementById(`listPrice${rowCounter}`);
			ePrice.value = row["precio"] ? row["precio"] :  "0.00";
			ePrice.focus();
			ePrice.blur();
			//$(`#qty${rowCounter}`).val(row["cantidad"]).focus().blur();
			let eCount = document.getElementById(`qty${rowCounter}`);
			eCount.value = row["cantidad"];
			eCount.focus();
			eCount.blur();

			console.log('Processing new row:', row["producto_nombre"]);
			// Increment counter for next row
			rowCounter++;
		}
	}
}

//Buscamos por la reglas establecidas de andres
function findExistingRowByCode(row) {
	
	//Obtenemos el codigo
	let codigo_busqueda = row["codigo"];
	let codigo_nuevo_busqueda = row["codigo_nuevo"];
	
	// Buscar en todas las filas existentes
	let existingRows = $("#lineItemTab .lineItemRow");
	
	for (let i = 1; i <= existingRows.length; i++) {
		let codigo_tabla = $(`#codigo${i}`).val();
		let codigo_nuevo_tabla = $(`#nuevo_codigo${i}`).val();
		
		//Validamos que el codigo tabla exista
		if(!codigo_tabla) return null;
		//La primera busqueda sera siempre por el codigo
		if (codigo_tabla.trim() == codigo_busqueda.trim()) {
			//console.log(existingRows[i-1],i);
			return i;
		}
		//Cuando existe codigo y nuevo codigo
		else if( codigo_nuevo_tabla && codigo_tabla.trim() == codigo_busqueda.trim() && codigo_nuevo_tabla.trim() == codigo_nuevo_busqueda.trim()){
			return i;
		}
		//Cuando hay codigo en la tabla y tiene un codigo nuevo el excel
		else if(codigo_nuevo_busqueda && codigo_tabla.trim() == codigo_nuevo_busqueda.trim()){
			return i;
		}
	}
	
	return null;
}

/**
 * Actualiza una fila existente con nuevos datos
 * @param {number} rowNumber - El número de la fila a actualizar
 * @param {Array} rowData - Los datos de la fila a aplicar
 */
function updateExistingRow(rowNumber, rowData) {
	// Actualizar los campos de la fila existente
	$(`#productName${rowNumber}`).val(rowData["producto_nombre"]);
	$(`#hdnProductId${rowNumber}`).val(rowData["producto_id"]);
	$(`#codigo${rowNumber}`).val(rowData["codigo"]);
	$(`#nuevo_codigo${rowNumber}`).val(rowData["codigo_nuevo"]);
	$(`#comment${rowNumber}`).val(rowData["descripcion_aleman"]);
	$(`#comentario_es${rowNumber}`).val(rowData["descripcion_espanol"]);

	//Aplicar los descuentos
	if(rowData["descuento_porcentaje"] || rowData["descuento_directo"]){

		if(rowData["descuento_directo"]){
			$(`input[name="discount${rowNumber}"]`).eq(2).prop('checked', true);
			$(`#discount_amount${rowNumber}`).val(rowData["descuento_directo"]);
		}else{
			$(`input[name="discount${rowNumber}"]`).eq(1).prop('checked', true);
			$(`#discount_percentage${rowNumber}`).val(rowData["descuento_porcentaje"]);
		}
	}
	// Aplicar los descuentos
	// $(`input[name="discount${rowNumber}"]`).prop('checked', true);
	// $(`#discount_amount${rowNumber}`).val(rowData["descuento_directo"]);
	
	// Actualizar precio y cantidad con trigger de eventos
	$(`#listPrice${rowNumber}`).val(rowData["precio"]).focus().blur();
	$(`#qty${rowNumber}`).val(rowData["cantidad"]).focus().blur();
	
}

//------------------------./
/**
 * Executes a dynamically generated function based on the _META object.
 * 
 * @param {Object} _META - An object containing the module and view information.
 * @param {string} _META.module - The module name, e.g., 'Accounts'.
 * @param {string} _META.view - The view name, e.g., 'Edit'.
 */
function executeMetaFunction(_META) {
	if (!_META?.module || !_META?.view) {
		console.error('Invalid _META object: "module" and "view" keys are required.');
		return;
	}

	const functionName = `${_META.module}${_META.view}_Init`;

	// Define and execute the function if it doesn't exist
	(window[functionName] ||= () => CLog.fn(`Executing ${functionName}`))();
}

/**
 * Ejecutar funciones por Modulos y Vistas
 * 	Declarado
 * 		- layouts/v7/modules/Vtiger/resources/Popup.js => Se ejecuta luego de dar clic al valor del Popup* 	
 * 		- registerEventForListViewEntryClick : function() 
 * 			-dentro de esta funcion 'popupPageContentsContainer.on('click','.listViewEntries',function(e))'	
 * 			
 * @param {_META.module}	=> Modulo 
 * @param {_META.view}		=> Vista
 */
function CaseModules() {
	CLog.setDebug(true)

	_META.URL = purl(window.document.URL).data.param.query;
	//Object.freeze(_META)
	debuglog(_META, '/resources/CreantisJsFooter.js');
	executeMetaFunction(_META)
	debuglog({}, 'CaseModules');
}



function initFormatAllView() {
	//FormatDobleAllView();
	//FormatNumberAllView();
}


/**
 * Hook Js
 * Declarado en => layouts/v7/modules/Vtiger/resources/Vtiger.js => ln 889
 * Funcion que se ejecuta al al limpiar un campo de modulo relacional
 * @param {*} fieldName =>nombre del campo
 */
function ClearForX_ModuleReference(fieldName) {
	CLog.fn('ClearForX_ModuleReference', fieldName)
}


/**
 * Hook Js
 * Declarado en => layouts/v7/modules/Vtiger/resources/Vtiger.js => ln 1542 :: registerPostReferenceEvent
 * Funcion que se ejecuta al realizar una accion en el campo de modulo relacional
 * @param {*} obj  => modulename, id, input_name
 */
function ReferenceFieldModuleGetDataCase(obj) {
	CLog.fn('ReferenceFieldModuleGetDataCase -> objref', obj);

	requestData(obj.modulerel, 'GetData', obj.idmodulerel)
		.then(function (data) {
			if (data['success']) {
				let dt = data.result.data;
				console.log('AppConnector', dt);

				// Si el módulo actual es 'Accounts' y el registro fuente es de tipo 'Ubigeo'
				if (obj.module === "Accounts" && dt.record_module === "Ubigeo") {
					//(field) : comercial
					Ubigeo_GetData({
						departamento: { name: 'ship_pobox', value: dt.ubigeo_tks_departamento },
						distrito: { name: 'ship_city', value: dt.ubigeo_tks_distrito },
						provincia: { name: 'ship_state', value: dt.ubigeo_tks_provincia },
						pais: { name: 'bill_country', value: dt.ubigeo_tks_pais },
					});
				}

				// Si el módulo actual es 'Contacts' y el registro fuente es de tipo 'Ubigeo'
				if (obj.module === "Contacts" || obj.module === "Accounts" && dt.record_module === "Ubigeo")
					//(field) : comercial
					Ubigeo_GetData({
						departamento: { name: 'mailingpobox', value: dt.ubigeo_tks_departamento },
						distrito: { name: 'mailingcity', value: dt.ubigeo_tks_distrito },
						provincia: { name: 'mailingstate', value: dt.ubigeo_tks_provincia },
						pais: { name: 'mailingcountry', value: '' },
					});

			}
		})

}


/**
 * Hook Js
 * Declarado en => layouts/v7/modules/Vtiger/resources/Detail.js::registerRelatedRowClickEvent => ln 673
 * Declarado en => layouts/v7/modules/Vtiger/resources/Edit.js::registerPageLeaveEvents => ln 350
 * Funcion que se ejecuta para traer el diccionario SC y bloquear campos 
 * @param {*} fieldName =>nombre del campo
 */
function EventsEditDetailModuleRelation(modulo, view, record) {
	CLog.fn('EventsEditDetailModuleRelation', modulo, view, record);
	initFormatAllView()
}


/**
 * Declarado en => layouts/v7/modules/Vtiger/resources/Detail.js => ln 747 :registerEventsForRelatedList
 * Funcion que se ejecuta despues de cargar una lista relacional
 */
function FinallyLoadListRel() {
	CLog.fn('FinallyLoadListRel')
	initFormatAllView()
	/*
	.finally( ()=>{
		//Creantis - cgarcia llamado despues de cargar una lista 
		if (typeof FinallyLoadListRel === 'function') FinallyLoadListRel();
		
	})
	debugger
*/
}

/**
 * Declarado en => layouts/v7/modules/Vtiger/resources/Detail.js => ln 1408 :registerAjaxEditSaveEvent
 * Funcion que se ejecuta despues de guardar de manera individual un campo
 */
function AffterSaveFieldValues(response) {
	CLog.fn('AffterSaveFieldValues')
	AffterSaveFieldValues()
}


/**
 * Declarado en => layouts/v7/modules/Inventory/resources/Edit.jss => ln 1607 :showLineItemPopup
 * Funcion que se ejecuta despues de cerrar el popup creado
 */
function PreFinallymapResultsToFields( data){
	CLog.fn('PreFinallymapResultsToFields',data)
}

/**
 * Declarado en => layouts/v7/modules/Inventory/resources/Edit.jss => ln 1524 :mapResultsToFields
 * Funcion que se ejecuta despues de seleccionar el producto
 */
 async function FinallymapResultsToFields(record ,data ){
	CLog.fn('FinallymapResultsToFields',[record, data])
}

document.addEventListener("DOMContentLoaded", () => CaseModules(), initFormatAllView());
document.addEventListener("DOMContentLoaded", function (event) { });

