<?php
/*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */

include_once dirname(__FILE__) . '/models/SearchFilter.php';

class CTMobile_WS_GetFileUrlUsingMsgId extends CTMobile_WS_Controller {
	
	function process(CTMobile_API_Request $request) {
		$default_charset = VTWS_PreserveGlobal::getGlobal('default_charset');
		global $current_user, $adb, $site_URL; // Few core API assumes this variable availability
		$current_user = $this->getActiveUser();
		$MessageId = $request->get('MessageId');
		
		$query = "SELECT * FROM vtiger_ctwhatsapp WHERE msgid = ?";
		$results = $adb->pquery($query,array($MessageId));
		$fileName = "";
		$type = "";
		$mimetype = "";
		$filesize = "";
		$pathinfo = array();
		if($adb->num_rows($results)){
			$message_body = $adb->query_result($results, 0, 'message_body');
			$pathinfo = pathinfo($message_body);
			if($pathinfo['extension']){
				/*if (function_exists('finfo_open')) {
			        $finfo = finfo_open(FILEINFO_MIME_TYPE);
			        $mimetype = finfo_file($finfo, $pathinfo['basename']);
			        finfo_close($finfo);
			    }else {
			        $mimetype = get_mime_type($pathinfo['extension']);
			    }*/
			    $mimetype = get_mime_type($pathinfo['extension']);
				$type = $pathinfo['extension'];
				$fileName = $pathinfo['basename'];
				//$message_body = urlencode($message_body);
				$message_body = str_replace(' ', '%20', $message_body);
				$result = get_remote_file_info($message_body);
				$filesize = sizeFilter($result['fileSize']);
			}
		}
		$message_body = decode_html(decode_html(urldecode($message_body)));
		$data = array('fileName'=>$fileName,'type'=>$mimetype,'fileurl'=>$message_body,'filesize'=>$filesize);

		$response = new CTMobile_API_Response();
		$response->setResult($data);
		return $response;
	}

	function getActiveNumber($current_user){
		$currenUserID = $current_user->id;
        $configurationData = Settings_CTWhatsApp_Record_Model::getUserConfigurationAllDataWithId($currenUserID);
        $allUserNumber = CTWhatsApp_Record_Model::getAllUserWhatsappNumber($currenUserID);
        $connectedNumbers = array();
        foreach ($allUserNumber as $key => $value) {
        	$connectedNumbers[] = $value;
        }
        return $connectedNumbers;
	}

}

function get_mime_type($idx) {
    /*$idx = explode( '.', $filename );
    $count_explode = count($idx);
    $idx = strtolower($idx[$count_explode-1]);*/

    $mimet = array( 
        'txt' => 'text/plain',
        'htm' => 'text/html',
        'html' => 'text/html',
        'php' => 'text/html',
        'css' => 'text/css',
        'js' => 'application/javascript',
        'json' => 'application/json',
        'xml' => 'application/xml',
        'swf' => 'application/x-shockwave-flash',
        'flv' => 'video/x-flv',

        // images
        'png' => 'image/png',
        'jpe' => 'image/jpeg',
        'jpeg' => 'image/jpeg',
        'jpg' => 'image/jpeg',
        'gif' => 'image/gif',
        'bmp' => 'image/bmp',
        'ico' => 'image/vnd.microsoft.icon',
        'tiff' => 'image/tiff',
        'tif' => 'image/tiff',
        'svg' => 'image/svg+xml',
        'svgz' => 'image/svg+xml',

        // archives
        'zip' => 'application/zip',
        'rar' => 'application/x-rar-compressed',
        'exe' => 'application/x-msdownload',
        'msi' => 'application/x-msdownload',
        'cab' => 'application/vnd.ms-cab-compressed',

        // audio/video
        'mp3' => 'audio/mpeg',
        'qt' => 'video/quicktime',
        'mov' => 'video/quicktime',
        'avi' => 'video/x-msvideo',
        'mp4' => 'video/mp4',
        'mpeg' => 'video/mpeg',
        'ogv' => 'video/ogg',
        'oga' => 'audio/ogg',
        'webm' => 'video/webm',
        'm4a'=> 'audio/m4a',
        

        // adobe
        'pdf' => 'application/pdf',
        'psd' => 'image/vnd.adobe.photoshop',
        'ai' => 'application/postscript',
        'eps' => 'application/postscript',
        'ps' => 'application/postscript',

        // ms office
        'doc' => 'application/msword',
        'rtf' => 'application/rtf',
        'xls' => 'application/vnd.ms-excel',
        'ppt' => 'application/vnd.ms-powerpoint',
        'docx' => 'application/msword',
        'xlsx' => 'application/vnd.ms-excel',
        'pptx' => 'application/vnd.ms-powerpoint',


        // open office
        'odt' => 'application/vnd.oasis.opendocument.text',
        'ods' => 'application/vnd.oasis.opendocument.spreadsheet',
        'ovpn' => 'application/x-openvpn-profile',
    );

    if (isset( $mimet[$idx] )) {
     return $mimet[$idx];
    } else {
     return '';
    }
 }

 function get_remote_file_info($url) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
    curl_setopt($ch, CURLOPT_HEADER, TRUE);
    curl_setopt($ch, CURLOPT_NOBODY, TRUE);
    $data = curl_exec($ch);
    $fileSize = curl_getinfo($ch, CURLINFO_CONTENT_LENGTH_DOWNLOAD);
    $httpResponseCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    return [
        'fileExists' => (int) $httpResponseCode == 200,
        'fileSize' => (int) $fileSize
    ];
}

function sizeFilter( $bytes )
{
    $label = array( 'B', 'KB', 'MB', 'GB', 'TB', 'PB' );
    for( $i = 0; $bytes >= 1024 && $i < ( count( $label ) -1 ); $bytes /= 1024, $i++ );
    return( round( $bytes, 2 ) . " " . $label[$i] );
}