<?php
/*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */

class CTMobile_WS_GetWhatsAppTemplateValue extends CTMobile_WS_Controller {
	
	function process(CTMobile_API_Request $request) {
		$default_charset = VTWS_PreserveGlobal::getGlobal('default_charset');
		global $current_user, $adb, $site_URL,$root_directory; // Few core API assumes this variable availability
		$current_user = $this->getActiveUser();
        
        $moduleRecordid = $request->get('recordid');
        $wptemplateid = $request->get('wptemplateid');
        $message = $request->get('message');
		
        if($wptemplateid){
            if(filter_var($message, FILTER_VALIDATE_URL)){
                $message = "";
            }else{
                if($moduleRecordid){
                    $setype = VtigerCRMObject::getSEType($moduleRecordid);
                    $message = getMergedDescription($message,$moduleRecordid,$setype);
                }
            }
        }
		$response = new CTMobile_API_Response();
		$response->setResult(array("message"=>$message));
		return $response;
	}

}
