<?php
 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */


class CTMobile_WS_TimeTrackingReport extends CTMobile_WS_Controller {
	
	function process(CTMobile_API_Request $request) {
		global $current_user,$adb;
		$current_user = $this->getActiveUser();
		$default_charset = VTWS_PreserveGlobal::getGlobal('default_charset');
		$presence = array('0', '2');
		$response = new CTMobile_API_Response();
		$user_id = $request->get('user_id');
		$daterange = $request->get('daterange');
		
		if($daterange != ''){
			$date = explode(' - ',$daterange);
			$date1 = date("Y-m-d", strtotime($date[0]));
			$date2 = date("Y-m-d", strtotime($date[1]));
		}
	
		$index = trim($request->get('index'));
		$size = trim($request->get('size'));
		$limit = ($index*$size) - $size;
		
		
		$data = array();
		$sql = "SELECT vtiger_cttimetracker.*,vtiger_crmentity.createdtime,vtiger_crmentity.modifiedtime FROM vtiger_cttimetracker INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_cttimetracker.cttimetrackerid WHERE vtiger_crmentity.deleted = 0 AND vtiger_crmentity.crmid > 0 ";

		if(!empty($user_id))
			$sql.=" AND vtiger_cttimetracker.tracking_user = '$user_id'";

		if(!empty($daterange))
			$sql.=" AND DATE(vtiger_crmentity.createdtime) BETWEEN '$date1' AND '$date2' ";
		
		$sql.= " ORDER BY vtiger_crmentity.modifiedtime DESC";
		$totalQuery = $sql;
		if($index != '' && $size != ''){
			$sql.= " LIMIT $limit, $size";
		}
		
		$result1 = $adb->pquery($totalQuery,array());
		$recordsTotal = $adb->num_rows($result1);
		$result2 = $adb->pquery($sql,array());
		$numofrows = $adb->num_rows($result2);
		$last_latitude = '';
		$last_longitude = '';
		$isLast = true;
		$user_total_duration = 0;
		for($i=0;$i<$numofrows;$i++){
			$row = $adb->query_result_rowdata($result2,$i);
			$related_to = $row['related_to'];

			$setype = '';
			$modulelabel = '';
			if($related_to != ''){
				$rel_query = "SELECT * FROM vtiger_crmentity WHERE crmid = ?";
				$rel_Results = $adb->pquery($rel_query,array($related_to));
				$setype = $adb->query_result($rel_Results,0,'setype');
				if($setype == 'Events'){
					$moduleModels = Vtiger_Module_Model::getInstance('Calendar');
				}else{
					$moduleModels = Vtiger_Module_Model::getInstance($setype);
				}
				if(!in_array($moduleModels->get('presence'), $presence)){
					continue;
				}
				$label = $adb->query_result($rel_Results,0,'label');
				if($setype == 'Events' || $setype == 'Calendar'){
					$calendarRecordModel = Vtiger_Record_Model::getInstanceById($related_to);
					if($calendarRecordModel->get('activitytype') == 'Task'){
						$setype = 'Calendar';
					}else{
						$setype = 'Events';
					}
				}
				$row['related_to'] = array('value'=>vtws_getWebserviceEntityId($setype, $related_to),'label'=>html_entity_decode($label,ENT_QUOTES,$default_charset));
			}else{
				$row['related_to'] = array('value'=>'','label'=>'');
			}

			if($row['createdtime'] != ''){
				$row['createdtime'] = Vtiger_Util_Helper::convertDateTimeIntoUsersDisplayFormat($row['createdtime']);
			}
			if($row['modifiedtime'] != ''){
				$row['modifiedtime'] = Vtiger_Util_Helper::convertDateTimeIntoUsersDisplayFormat($row['modifiedtime']);
			}
			if($row['tracking_user'] != ''){
				$userRecordModel = Vtiger_Record_Model::getInstanceById($row['tracking_user'],'Users');
				if(!empty($userRecordModel->get('user_name'))){
					$row['tracking_user'] = array('value'=>vtws_getWebserviceEntityId('Users', $row['tracking_user']),'label'=>html_entity_decode($userRecordModel->get('first_name').' '.$userRecordModel->get('last_name'),ENT_QUOTES,$default_charset));
				}else{
					$query = "SELECT groupname FROM vtiger_groups WHERE groupid = ?";
					$groupResults = $adb->pquery($query,array($row['tracking_user']));
					$row['tracking_user'] = array('value'=>vtws_getWebserviceEntityId('Groups', $row['tracking_user']),'label'=>html_entity_decode($adb->query_result($groupResults,0,'groupname'),ENT_QUOTES,$default_charset));
				}
			}

			$total_time = $row['total_time'];
			$user_total_duration += $total_time;
			$hours = floor($total_time / 3600);
		    $minutes = floor(($total_time / 60) % 60);
		    $seconds = $total_time % 60;

		    $user_total_time = "$hours:$minutes:$seconds";
			
			if(Users_Privileges_Model::isPermitted('CTTimeTracker', 'DetailView', $row['cttimetrackerid'])){
				array_push($data,array('cttimetrackerid'=>$row['cttimetrackerid'],'tracking_title'=>decode_html(decode_html($row['tracking_title'])),'tracking_status'=>$row['tracking_status'],'tracking_notes'=>decode_html(decode_html($row['tracking_notes'])),'total_time'=>$row['total_time'],'user_total_time'=>$user_total_time,'related_to'=>$row['related_to'],'createdtime'=>$row['createdtime'],'modifiedtime'=>$row['createdtime'],'check_in_location'=>$row['check_in_location'],'check_out_location'=>$row['check_out_location']));
			}
		}

		$hours = floor($user_total_duration / 3600);
		$minutes = floor(($user_total_duration / 60) % 60);
		$seconds = $user_total_duration % 60;
		$user_total_duration = "$hours:$minutes:$seconds";

		if($index && $size){
			if($recordsTotal > $index*$size){
				$isLast = false;
			}else{
				$isLast = true;
			}
		}


		$users = array();
		$USER_MODEL = Users_Record_Model::getCurrentUserModel();
		$AccessibleUsers = $USER_MODEL->getAccessibleUsers();
		foreach ($AccessibleUsers as $userid => $username) {
			array_push($users,array('value'=>$userid,'label'=>$username));
		}
		
		if(count($data) == 0){
			$message = $this->CTTranslate('No records found');
			$response->setResult(array('Data'=>array(),'code'=>404,'message'=>$message,'isLast'=>$isLast,'recordsTotal'=>$recordsTotal,'users'=>$users));
		}else{
			$response->setResult(array('Data'=>$data,'isLast'=>$isLast,'recordsTotal'=>$recordsTotal,'users'=>$users,'user_total_duration'=>$user_total_duration));
		}
		
		return $response;
	}
	
}
